/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet;

import com.comphenix.protocol.injector.packet.MapContainer;
import com.google.common.base.Predicate;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;

public class InverseMaps {
    private InverseMaps() {
    }

    public static <K, V> Multimap<K, V> inverseMultimap(final Map<V, K> map, final Predicate<Map.Entry<V, K>> filter) {
        final MapContainer container = new MapContainer(map);
        return new ForwardingMultimap<K, V>(){
            private Multimap<K, V> inverseMultimap;

            protected Multimap<K, V> delegate() {
                if (container.hasChanged()) {
                    this.inverseMultimap = HashMultimap.create();
                    for (Map.Entry entry : map.entrySet()) {
                        if (!filter.apply(entry)) continue;
                        this.inverseMultimap.put(entry.getValue(), entry.getKey());
                    }
                    container.setChanged(false);
                }
                return this.inverseMultimap;
            }
        };
    }

    public static <K, V> Map<K, V> inverseMap(final Map<V, K> map, final Predicate<Map.Entry<V, K>> filter) {
        final MapContainer container = new MapContainer(map);
        return new ForwardingMap<K, V>(){
            private Map<K, V> inverseMap;

            protected Map<K, V> delegate() {
                if (container.hasChanged()) {
                    this.inverseMap = Maps.newHashMap();
                    for (Map.Entry entry : map.entrySet()) {
                        if (!filter.apply(entry)) continue;
                        this.inverseMap.put(entry.getValue(), entry.getKey());
                    }
                    container.setChanged(false);
                }
                return this.inverseMap;
            }
        };
    }
}

