/*
 * Decompiled with CFR 0.152.
 */
package me.sayaad.CCTV.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Scanner;
import me.sayaad.CCTV.misc.VAR;
import me.sayaad.CCTV.util.Camera;
import me.sayaad.CCTV.util.Link;
import me.sayaad.CCTV.util.Screen;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class API {
    public static void checkConfig(FileConfiguration config) {
        try {
            File Config = VAR.configFile;
            config.set("Camera.Camera Block IDS", (Object)config.getString("Camera.Camera Block IDS", "49,19,23"));
            config.set("Camera.Camera can be dispensor", (Object)config.getBoolean("Camera.Camera can be dispensor", true));
            config.set("Screen.Screen Block IDS", (Object)config.getString("Screen.Screen Block IDS", "35:15,35:7"));
            config.set("CCTV.Create Glowstone under camera", (Object)config.getBoolean("CCTV.Create Glowstone under camera", true));
            config.set("CCTV.Invisible while viewing camera", (Object)config.getBoolean("CCTV.Invisible while viewing camera", true));
            config.set("CCTV.Invisible while viewing camera", (Object)config.getBoolean("CCTV.Invisible while viewing camera", true));
            config.save(Config);
        }
        catch (Exception e) {
            VAR.log.severe("[CCTV Camera] An error occured checking the config file. Please make a ticket of this error :\n");
            e.printStackTrace();
        }
    }

    public static void getLinks() {
        VAR.Links.clear();
        try {
            Scanner file = new Scanner(VAR.LinksFile);
            VAR.Links.clear();
            while (file.hasNextLine()) {
                VAR.Links.add(API.getLinkFromFormattedString(file.nextLine()));
            }
            file.close();
        }
        catch (IOException e) {
            VAR.log.severe("[CCTV Camera] An error occured reading and adding to the LinksLocation Array. Please make a ticket of this error :\n");
            e.printStackTrace();
        }
    }

    public static void addLink(Link link, Player p) {
        if (VAR.camera.getLocation() != null && VAR.screen.getLocation() != null) {
            String message = link.ToFormattedString(p);
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(VAR.LinksFile, true));
                writer.write(message);
                writer.newLine();
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                VAR.log.severe("[CCTV Camera] An error occured adding to Link File. Please make a ticket of this error :\n");
                e.printStackTrace();
            }
            API.getLinks();
        }
    }

    public static void goToCamera(Player player, Location loc, Material mat) {
        VAR.cameraUsers.add(player.getName());
        Location loc2 = loc;
        loc.getBlock().setType(Material.GLASS);
        loc.setX(loc.getX() + 0.5);
        loc.setZ(loc.getZ() + 0.5);
        loc.setY(loc.getY() - 1.0);
        VAR.previousIDs.add(String.valueOf(player.getName()) + ":" + loc.getBlock().getTypeId());
        if (VAR.config.getBoolean("CCTV.Create Glowstone under camera")) {
            loc.getBlock().setType(Material.GLOWSTONE);
        } else {
            loc.getBlock().setType(Material.GLASS);
        }
        if (VAR.config.getBoolean("CCTV.Invisible while viewing camera")) {
            Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                if (!p.getName().equalsIgnoreCase(player.getName())) {
                    p.hidePlayer(player);
                    p.sendBlockChange(loc2, mat, (byte)0);
                }
                ++n2;
            }
        }
        player.teleport(loc);
        player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 2000000000, 1));
        player.sendMessage(ChatColor.GREEN + "[CCTV Camera] Right-Click to exit the view.");
    }

    public static void exitCamera(Player player, Location loc) {
        VAR.cameraUsers.remove(player.getName());
        if (VAR.config.getBoolean("CCTV.Invisible while viewing camera")) {
            Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                p.showPlayer(player);
                ++n2;
            }
        }
        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        if (VAR.dispensorCameraUsers.contains(player.getName())) {
            VAR.dispensorCameraUsers.remove(player.getName());
        }
        for (Map.Entry<Player, Location> entry : VAR.backlocation.entrySet()) {
            if (!entry.getKey().equals(player)) continue;
            player.teleport(entry.getValue());
        }
        API.getLinks();
        int i = 0;
        while (i < VAR.Links.size()) {
            Link link = VAR.Links.get(i);
            if (link.getCamera().getLocation().equals((Object)loc)) {
                BlockFace blockFace = link.getCamera().getBLockFace();
                Byte data = 0;
                if (blockFace.equals((Object)BlockFace.SOUTH)) {
                    data = 2;
                } else if (blockFace.equals((Object)BlockFace.EAST)) {
                    data = 1;
                } else if (blockFace.equals((Object)BlockFace.WEST)) {
                    data = 3;
                }
                if (VAR.CamerasInUse.contains(link.getCamera())) {
                    VAR.CamerasInUse.remove(link.getCamera());
                }
                if (loc.getBlock().getTypeId() == 20) {
                    loc.getBlock().setTypeIdAndData(link.getCamera().getMaterial().getId(), data.byteValue(), false);
                }
                Location loc2 = new Location(loc.getWorld(), loc.getX(), loc.getY() - 1.0, loc.getZ());
                String toRemove = "null";
                for (String s : VAR.previousIDs) {
                    String playerName = s.split(":")[0];
                    int id = Integer.valueOf(s.split(":")[1]);
                    if (!player.getName().equals(playerName)) continue;
                    if (id == link.getCamera().getBlockUnderCamID()) {
                        loc2.getBlock().setTypeId(link.getCamera().getBlockUnderCamID());
                    } else {
                        loc2.getBlock().setTypeId(id);
                    }
                    toRemove = s;
                }
                if (VAR.previousIDs.contains(toRemove)) {
                    VAR.previousIDs.remove(toRemove);
                }
            }
            ++i;
        }
    }

    public static Link getLinkFromFormattedString(String string) {
        String[] derp = string.split("/");
        String[] cameraInfo = derp[0].split(",");
        String[] cameraLocationInfo = cameraInfo[0].split("=");
        String[] screenInfo = derp[1].split(",");
        String[] screenLocationInfo = screenInfo[0].split("=");
        String[] linkInfo = derp[2].split(",");
        String cameraName = cameraInfo[1];
        String screenName = screenInfo[1];
        String creatorName = linkInfo[1];
        Material cameraMaterial = Material.getMaterial((String)cameraInfo[2]);
        Material screenMaterial = Material.getMaterial((String)screenInfo[2]);
        BlockFace cameraBlockFace = BlockFace.valueOf((String)cameraInfo[3]);
        int BlockUnderCamId = Integer.parseInt(derp[3]);
        Location screenLocation = new Location(Bukkit.getWorld((String)screenLocationInfo[3]), Double.parseDouble(screenLocationInfo[0]), Double.parseDouble(screenLocationInfo[1]), Double.parseDouble(screenLocationInfo[2]));
        Location cameraLocation = new Location(Bukkit.getWorld((String)cameraLocationInfo[3]), Double.parseDouble(cameraLocationInfo[0]), Double.parseDouble(cameraLocationInfo[1]), Double.parseDouble(cameraLocationInfo[2]));
        boolean isPublic = Boolean.valueOf(linkInfo[0]);
        Camera camera = new Camera(cameraLocation, cameraName, cameraMaterial, cameraBlockFace, BlockUnderCamId);
        Screen screen = new Screen(screenLocation, screenName, screenMaterial);
        return new Link(camera, screen, isPublic, creatorName);
    }

    public static void removeLineFromFile(String file, String lineToRemove) {
        try {
            VAR.Links.clear();
            File inFile = new File(file);
            File tempFile = new File(String.valueOf(VAR.dataDir) + "temp" + ".tmp");
            BufferedReader br = new BufferedReader(new FileReader(file));
            PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().contains(lineToRemove)) continue;
                pw.println(line);
                pw.flush();
            }
            pw.close();
            br.close();
            if (!inFile.delete()) {
                VAR.log.severe("[CCTV] Could not delete links file!");
            } else {
                tempFile.renameTo(inFile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        API.getLinks();
    }

    public static void clearVars() {
        VAR.playerUsing = "";
        VAR.camera = new Camera(null, null, null, null, 0);
        VAR.screen = new Screen(null, null, null);
        VAR.isPublic = false;
    }
}

