/*
 * Decompiled with CFR 0.152.
 */
package me.sayaad.CCTV;

import java.io.File;
import java.io.IOException;
import me.sayaad.CCTV.listener;
import me.sayaad.CCTV.misc.API;
import me.sayaad.CCTV.misc.MetricsLite;
import me.sayaad.CCTV.misc.VAR;
import me.sayaad.CCTV.util.Link;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class main
extends JavaPlugin {
    private final listener l = new listener();

    public void onEnable() {
        VAR.log.info("[CCTV Camera] Enabled!");
        VAR.config = this.getConfig();
        File f = new File(VAR.mainDir);
        f.mkdir();
        new File(VAR.dataDir).mkdir();
        if (!VAR.configFile.exists()) {
            try {
                VAR.configFile.createNewFile();
                API.checkConfig(VAR.config);
                VAR.log.info("[CCTV Camera] Config File successfully created!");
            }
            catch (IOException e) {
                VAR.log.severe("[CCTV Camera] An error occured creating the config.yml file. Please make a ticket of this error:\n");
                e.printStackTrace();
            }
        }
        if (VAR.LinksFile.exists()) {
            VAR.log.info("[CCTV Camera] Getting Links...");
            API.getLinks();
            VAR.log.info("[CCTV Camera] Links successfully added to array");
        } else {
            VAR.log.info("[CCTV Camera] Link file not found, Creating now...");
            try {
                VAR.LinksFile.createNewFile();
                VAR.log.info("[CCTV Camera] Link file successfully created!");
            }
            catch (IOException e) {
                VAR.log.info("[CCTV Camera] An error occured in Creating the Link File. Please make a ticket of this error :\n");
                e.printStackTrace();
            }
        }
        API.checkConfig(VAR.config);
        this.getServer().getPluginManager().registerEvents((Listener)this.l, (Plugin)this);
        try {
            main plugin = this;
            MetricsLite metrics = new MetricsLite((Plugin)plugin);
            metrics.start();
        }
        catch (IOException e) {
            VAR.log.severe("[CCTV Camera] Metrics failed to send data!");
        }
    }

    public void onDisable() {
        VAR.log.info("[CCTV Camera] Disabled!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender cmdsender, Command command, String label, String[] args) {
        String cmd = command.getName().toLowerCase();
        if (cmdsender instanceof Player) {
            Player sender = (Player)cmdsender;
            if (cmd.equals("cctv")) {
                if (args.length == 0) {
                    sender.sendMessage(ChatColor.GRAY + "=-=-=-=-=-CCTV Camera Commands-=-=-=-=-=");
                    sender.sendMessage("");
                    sender.sendMessage(ChatColor.RED + "Enter the first three commands in the order shown to you to avoid unwanted errors");
                    sender.sendMessage(ChatColor.GRAY + "/cctv create camera <camera name> - " + ChatColor.GOLD + "Enter Camera Creation Mode.");
                    sender.sendMessage(ChatColor.GRAY + "/cctv create screen <screen name> - " + ChatColor.GOLD + "Enter Screen Creation Mode.");
                    sender.sendMessage(ChatColor.GRAY + "/cctv link - " + ChatColor.GOLD + "Links created camera and screen");
                    sender.sendMessage(ChatColor.GRAY + "/cctv delete link - " + ChatColor.GOLD + "Enter Link Deletion Mode.");
                    sender.sendMessage(ChatColor.GRAY + "/cctv modify public <True|False> - " + ChatColor.GOLD + "Sets the camera mode being created to public or not");
                    sender.sendMessage("");
                    sender.sendMessage(ChatColor.GRAY + "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
                    return true;
                }
                if (args[0].equalsIgnoreCase("create")) {
                    if (VAR.playerUsing.equals(sender.getName()) || VAR.playerUsing.equals("")) {
                        if (sender.hasPermission("cctv.create")) {
                            VAR.playerUsing = sender.getName();
                            if (args[1].equalsIgnoreCase("camera")) {
                                if (args.length > 2) {
                                    VAR.cameraCreateMode.add(sender.getName());
                                    VAR.camera.setName(args[2]);
                                    VAR.playerUsing = sender.getName();
                                    sender.sendMessage(ChatColor.GOLD + "[CCTV Camera] " + ChatColor.GREEN + "Please Left-Click a block to set it as camera '" + ChatColor.GOLD + args[2] + ChatColor.GREEN + "'");
                                    return true;
                                }
                                sender.sendMessage(ChatColor.RED + "Too Few Arguments; Usage - /cctv create camera <Name>");
                                return true;
                            }
                            if (!args[1].equalsIgnoreCase("screen")) return true;
                            if (args.length > 2) {
                                VAR.screenCreateMode.add(sender.getName());
                                VAR.screen.setName(args[2]);
                                VAR.playerUsing = sender.getName();
                                sender.sendMessage(ChatColor.GOLD + "[CCTV Camera] " + ChatColor.GREEN + "Please Right-Click a block to set it as screen '" + ChatColor.GOLD + args[2] + ChatColor.GREEN + "'");
                                return true;
                            }
                            sender.sendMessage(ChatColor.RED + "Too Few Arguments; Usage - /cctv create screen <Name>");
                            return true;
                        }
                        sender.sendMessage(ChatColor.RED + "You do not have permission");
                        return true;
                    }
                    sender.sendMessage(ChatColor.GOLD + "[CCTV Camera] " + ChatColor.RED + "Someone is currently setting up a camera. Please wait");
                    return true;
                }
                if (args[0].equalsIgnoreCase("link") && (VAR.playerUsing == sender.getName() || VAR.playerUsing == "")) {
                    if (sender.hasPermission("cctv.create")) {
                        Link link = new Link(VAR.camera, VAR.screen, VAR.isPublic, sender.getName());
                        sender.sendMessage("");
                        API.addLink(link, sender);
                        API.clearVars();
                        sender.sendMessage(ChatColor.GOLD + "[CCTV Camera] " + ChatColor.GREEN + "Link Created! Rightclick the screen at any point to view the camera. To exit the camera type /cctv exit");
                        return true;
                    }
                    sender.sendMessage(ChatColor.RED + "You do not have permission");
                    return true;
                }
                if (args[0].equalsIgnoreCase("modify") && args[1].equalsIgnoreCase("public") && args.length == 3) {
                    if (args[2].equalsIgnoreCase("true")) {
                        VAR.isPublic = true;
                        sender.sendMessage(ChatColor.GOLD + "[CCTV Camera] " + ChatColor.GREEN + "Camera was set to public");
                        return true;
                    }
                    if (args[2].equalsIgnoreCase("false")) {
                        VAR.isPublic = false;
                        sender.sendMessage(ChatColor.GOLD + "[CCTV Camera] " + ChatColor.GREEN + "Camera was set to creator only");
                        return true;
                    }
                }
                if (args[0].equalsIgnoreCase("delete")) {
                    if (args[1].equalsIgnoreCase("link")) {
                        sender.sendMessage(ChatColor.DARK_RED + "Are you sure you want to contine? If so, type /cctv delete confirm");
                        return true;
                    }
                    if (!args[1].equalsIgnoreCase("confirm")) return false;
                    sender.sendMessage(ChatColor.GOLD + "[CCTV Camera] " + ChatColor.RED + "Very well, left-click your screen or camera to delete the entire link, you will get back your blocks");
                    VAR.linkDeleteMode.add(sender.getName());
                    return true;
                }
                if (args[0].equalsIgnoreCase("exit")) {
                    if (VAR.cameraUsers.contains(sender.getName())) {
                        Location loc = new Location(sender.getWorld(), sender.getLocation().getX(), sender.getLocation().getY() + 1.0, sender.getLocation().getZ());
                        Location loc2 = loc.getBlock().getLocation();
                        API.exitCamera(sender, loc2);
                        return true;
                    }
                    sender.sendMessage(ChatColor.RED + "You are not inside of a camera and cannot leave.");
                    return true;
                }
            }
            if (!args[0].equalsIgnoreCase("test")) return false;
            if (!args[1].equalsIgnoreCase("vars")) return true;
            StringBuilder str2 = new StringBuilder();
            int i = 0;
            while (i < VAR.cameraCreateMode.size()) {
                str2.append(VAR.cameraCreateMode.get(i));
                str2.append(", ");
                ++i;
            }
            sender.sendMessage("cameraCreateMode : " + str2.toString());
            StringBuilder str3 = new StringBuilder();
            int i2 = 0;
            while (i2 < VAR.screenCreateMode.size()) {
                str3.append(VAR.screenCreateMode.get(i2));
                str3.append(", ");
                ++i2;
            }
            sender.sendMessage("screenCreateMode : " + str3.toString());
            return true;
        }
        cmdsender.sendMessage("You must be a player to use CCTV commands.");
        return true;
    }
}

