/*
 * Decompiled with CFR 0.152.
 */
package com.xxmicloxx.NoteBlockAPI;

import com.xxmicloxx.NoteBlockAPI.Instrument;
import com.xxmicloxx.NoteBlockAPI.Layer;
import com.xxmicloxx.NoteBlockAPI.Note;
import com.xxmicloxx.NoteBlockAPI.NoteBlockPlayerMain;
import com.xxmicloxx.NoteBlockAPI.NotePitch;
import com.xxmicloxx.NoteBlockAPI.Song;
import com.xxmicloxx.NoteBlockAPI.SongPlayer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class NoteBlockSongPlayer
extends SongPlayer {
    private Block noteBlock;

    public NoteBlockSongPlayer(Song song) {
        super(song);
    }

    public Block getNoteBlock() {
        return this.noteBlock;
    }

    public void setNoteBlock(Block noteBlock) {
        this.noteBlock = noteBlock;
    }

    public void playTick(Player p, int tick) {
        if (this.noteBlock.getType() != Material.NOTE_BLOCK) {
            return;
        }
        if (!p.getWorld().getName().equals(this.noteBlock.getWorld().getName())) {
            return;
        }
        byte playerVolume = NoteBlockPlayerMain.getPlayerVolume(p);
        for (Layer l : this.song.getLayerHashMap().values()) {
            Note note = l.getNote(tick);
            if (note == null) continue;
            p.playNote(this.noteBlock.getLocation(), Instrument.getBukkitInstrument(note.getInstrument()), new org.bukkit.Note(note.getKey() - 33));
            p.playSound(this.noteBlock.getLocation(), Instrument.getInstrument(note.getInstrument()), (float)(l.getVolume() * this.volume * playerVolume) / 1000000.0f, NotePitch.getPitch(note.getKey() - 33));
        }
    }
}

