/*
 * Decompiled with CFR 0.152.
 */
package com.xxmicloxx.NoteBlockAPI;

import com.xxmicloxx.NoteBlockAPI.Layer;
import com.xxmicloxx.NoteBlockAPI.Note;
import com.xxmicloxx.NoteBlockAPI.Song;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBSDecoder {
    public static Song parse(File decodeFile) {
        HashMap<Integer, Layer> layerHashMap = new HashMap<Integer, Layer>();
        try {
            short jumpTicks;
            DataInputStream dis = new DataInputStream(new FileInputStream(decodeFile));
            short length = NBSDecoder.readShort(dis);
            int songHeight = NBSDecoder.readShort(dis);
            String title = NBSDecoder.readString(dis);
            String author = NBSDecoder.readString(dis);
            NBSDecoder.readString(dis);
            String description = NBSDecoder.readString(dis);
            short speed = (short)(NBSDecoder.readShort(dis) / 100);
            dis.readBoolean();
            dis.readByte();
            dis.readByte();
            NBSDecoder.readInt(dis);
            NBSDecoder.readInt(dis);
            NBSDecoder.readInt(dis);
            NBSDecoder.readInt(dis);
            NBSDecoder.readInt(dis);
            NBSDecoder.readString(dis);
            int tick = -1;
            while ((jumpTicks = NBSDecoder.readShort(dis)) != 0) {
                short jumpLayers;
                tick = (short)(tick + jumpTicks);
                int layer = -1;
                while ((jumpLayers = NBSDecoder.readShort(dis)) != 0) {
                    layer = (short)(layer + jumpLayers);
                    NBSDecoder.setNote(layer, tick, dis.readByte(), dis.readByte(), layerHashMap);
                }
            }
            for (int i = 0; i < songHeight; ++i) {
                Layer l = (Layer)layerHashMap.get(i);
                if (l == null) continue;
                l.setName(NBSDecoder.readString(dis));
                l.setVolume(dis.readByte());
            }
            return new Song(speed, layerHashMap, (short)songHeight, length, title, author, description, decodeFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void setNote(int layer, int ticks, byte instrument, byte key, HashMap<Integer, Layer> layerHashMap) {
        Layer l = layerHashMap.get(layer);
        if (l == null) {
            l = new Layer();
            layerHashMap.put(layer, l);
        }
        l.setNote(ticks, new Note(instrument, key));
    }

    private static short readShort(DataInputStream dis) throws IOException {
        int byte1 = dis.readUnsignedByte();
        int byte2 = dis.readUnsignedByte();
        return (short)(byte1 + (byte2 << 8));
    }

    private static int readInt(DataInputStream dis) throws IOException {
        int byte1 = dis.readUnsignedByte();
        int byte2 = dis.readUnsignedByte();
        int byte3 = dis.readUnsignedByte();
        int byte4 = dis.readUnsignedByte();
        return byte1 + (byte2 << 8) + (byte3 << 16) + (byte4 << 24);
    }

    private static String readString(DataInputStream dis) throws IOException {
        int length;
        StringBuilder sb = new StringBuilder(length);
        for (length = NBSDecoder.readInt(dis); length > 0; --length) {
            char c = (char)dis.readByte();
            if (c == '\r') {
                c = ' ';
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

