/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.util;

import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.soundcenter.soundcenter.lib.data.Area;
import com.soundcenter.soundcenter.lib.data.Box;
import com.soundcenter.soundcenter.lib.data.SCLocation;
import com.soundcenter.soundcenter.lib.data.Station;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class IntersectionDetection {
    public static short playerCanHear(Player player1, Player player2, int range) {
        double dist;
        short distance = -1;
        Location loc1 = player1.getLocation();
        Location loc2 = player2.getLocation();
        if (loc1.getWorld().equals(loc2.getWorld()) && IntersectionDetection.locIsNear(loc1, loc2, range) && (dist = loc1.distance(loc2)) <= (double)range) {
            distance = (short)dist;
        }
        return distance;
    }

    public static boolean boxOverlaps(Box newBox) {
        double distance;
        SCLocation loc = newBox.getLocation();
        int radius = newBox.getRange();
        for (Map.Entry<Short, Station> entry : SoundCenter.database.boxes.entrySet()) {
            Station oldBox = entry.getValue();
            try {
                if (!IntersectionDetection.locIsNear(oldBox.getLocation(), loc, oldBox.getRange() + radius) || IntersectionDetection.isNaN(distance = oldBox.getLocation().distance(loc)) || !(distance < (double)(oldBox.getRange() + radius))) continue;
                return true;
            }
            catch (IllegalArgumentException distance2) {
                // empty catch block
            }
        }
        for (Map.Entry<Short, Station> entry : SoundCenter.database.areas.entrySet()) {
            Station area = entry.getValue();
            distance = IntersectionDetection.distToAreaBorder(loc, area, true);
            if (!(distance > 0.0 && distance < (double)radius) && (!(distance < 0.0) || !(Math.abs(distance) < (double)radius))) continue;
            return true;
        }
        for (Map.Entry<Short, Station> entry : SoundCenter.database.wgRegions.entrySet()) {
            ProtectedRegion region;
            Station wgRegion = entry.getValue();
            if (SoundCenter.getWorldGuard() == null || (region = SoundCenter.getWorldGuard().getRegionManager(Bukkit.getServer().getWorld(wgRegion.getWorld())).getRegion(wgRegion.getName())) == null || !region.contains(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())) continue;
            return true;
        }
        return false;
    }

    public static boolean areaOverlaps(Area newArea) {
        for (Map.Entry<Short, Station> entry : SoundCenter.database.boxes.entrySet()) {
            Station box = entry.getValue();
            int radius = box.getRange();
            double distance = IntersectionDetection.distToAreaBorder(box.getLocation(), newArea, true);
            if (!(distance > 0.0 && distance < (double)radius) && (!(distance < 0.0) || !(Math.abs(distance) < (double)radius))) continue;
            return true;
        }
        for (Map.Entry<Short, Station> entry : SoundCenter.database.areas.entrySet()) {
            Station oldArea = entry.getValue();
            if (!IntersectionDetection.areasIntersect(newArea, oldArea)) continue;
            return true;
        }
        for (Map.Entry<Short, Station> entry : SoundCenter.database.wgRegions.entrySet()) {
            ProtectedRegion region;
            Station wgRegion = entry.getValue();
            if (SoundCenter.getWorldGuard() == null || (region = SoundCenter.getWorldGuard().getRegionManager(Bukkit.getServer().getWorld(wgRegion.getWorld())).getRegion(wgRegion.getName())) == null) continue;
            if (region.contains(newArea.getMin().getBlockX(), newArea.getMin().getBlockY(), newArea.getMin().getBlockZ())) {
                return true;
            }
            if (!region.contains(newArea.getMax().getBlockX(), newArea.getMax().getBlockY(), newArea.getMax().getBlockZ())) continue;
            return true;
        }
        return false;
    }

    public static HashMap<Short, Double> inRangeOfBox(SCLocation loc) {
        HashMap<Short, Double> matches = new HashMap<Short, Double>();
        for (Map.Entry<Short, Station> entry : SoundCenter.database.boxes.entrySet()) {
            short id = entry.getKey();
            Station box = entry.getValue();
            SCLocation center = box.getLocation();
            try {
                double distance;
                if (!IntersectionDetection.locIsNear(center, loc, box.getRange()) || IntersectionDetection.isNaN(distance = center.distance(loc)) || !(distance <= (double)box.getRange())) continue;
                matches.put(id, distance);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return matches;
    }

    public static HashMap<Short, Double> isInArea(SCLocation loc) {
        HashMap<Short, Double> matches = new HashMap<Short, Double>();
        for (Map.Entry<Short, Station> entry : SoundCenter.database.areas.entrySet()) {
            short id = entry.getKey();
            Station area = entry.getValue();
            double distance = IntersectionDetection.distToAreaBorder(loc, area, false);
            if (!(distance > 0.0)) continue;
            matches.put(id, distance);
        }
        return matches;
    }

    private static double distToAreaBorder(SCLocation loc, Station area, Boolean calcDistIfOutside) {
        if (!loc.getWorld().equals(area.getWorld())) {
            return -1.0;
        }
        double dist = 0.0;
        boolean contains = false;
        SCLocation min = area.getMin();
        SCLocation max = area.getMax();
        boolean betweenX = false;
        boolean betweenY = false;
        boolean betweenZ = false;
        if (loc.getX() <= max.getX() && loc.getX() >= min.getX()) {
            betweenX = true;
        }
        if (loc.getY() <= max.getY() && loc.getY() >= min.getY()) {
            betweenY = true;
        }
        if (loc.getZ() <= max.getZ() && loc.getZ() >= min.getZ()) {
            betweenZ = true;
        }
        if (betweenX && betweenZ && betweenY) {
            contains = true;
        }
        if (contains || calcDistIfOutside.booleanValue()) {
            double distX = Math.min(Math.abs(min.getX() - loc.getX()), Math.abs(max.getX() - loc.getX()));
            double distY = Math.min(Math.abs(min.getY() - loc.getY()), Math.abs(max.getY() - loc.getY()));
            double distZ = Math.min(Math.abs(min.getZ() - loc.getZ()), Math.abs(max.getZ() - loc.getZ()));
            if (contains) {
                dist = Math.min(Math.min(distX, distY), Math.min(distZ, Math.min(distX, distY)));
            } else {
                dist = betweenX && betweenY ? distZ : (betweenX && betweenZ ? distY : (betweenY && betweenZ ? distX : (betweenX ? Math.sqrt(Math.pow(distY, 2.0) + Math.pow(distZ, 2.0)) : (betweenY ? Math.sqrt(Math.pow(distX, 2.0) + Math.pow(distZ, 2.0)) : (betweenZ ? Math.sqrt(Math.pow(distX, 2.0) + Math.pow(distY, 2.0)) : Math.sqrt(Math.pow(distX, 2.0) + Math.pow(distY, 2.0) + Math.pow(distZ, 2.0)))))));
                dist = -dist;
            }
        }
        return dist;
    }

    private static boolean areasIntersect(Station area1, Station area2) {
        if (!area1.getWorld().equals(area2.getWorld())) {
            return false;
        }
        SCLocation min1 = area1.getMin();
        SCLocation max1 = area1.getMax();
        SCLocation min2 = area2.getMin();
        SCLocation max2 = area2.getMax();
        return max1.getX() >= min2.getX() && min1.getX() <= max2.getX() && max1.getY() >= min2.getY() && min1.getY() <= max2.getY() && max1.getZ() >= min2.getZ() && min1.getZ() <= max2.getZ();
    }

    private static boolean locIsNear(Location loc1, Location loc2, int range) {
        return loc1.getWorld().equals(loc2.getWorld()) && Math.abs(loc1.getX() - loc2.getX()) <= (double)range && Math.abs(loc1.getY() - loc2.getY()) <= (double)range && Math.abs(loc1.getZ() - loc2.getZ()) <= (double)range;
    }

    private static boolean locIsNear(SCLocation loc1, SCLocation loc2, int range) {
        return loc1.getWorld().equals(loc2.getWorld()) && Math.abs(loc1.getX() - loc2.getX()) <= (double)range && Math.abs(loc1.getY() - loc2.getY()) <= (double)range && Math.abs(loc1.getZ() - loc2.getZ()) <= (double)range;
    }

    private static boolean isNaN(double x) {
        return x != x;
    }
}

