/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.network.udp;

import com.soundcenter.soundcenter.lib.udp.UdpPacket;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import com.soundcenter.soundcenter.plugin.network.udp.UdpSender;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;

public class UdpServer
implements Runnable {
    public static long totalVoiceDataRate = 0L;
    public boolean exit = false;
    public boolean active = false;
    public DatagramSocket datagramSocket = null;
    private UdpSender udpSender = null;
    private int udpPort = 4224;
    private String serverBindAddr = "0.0.0.0";

    public UdpServer(int port, String serverBindAddr) {
        this.udpPort = port;
        this.serverBindAddr = serverBindAddr;
    }

    @Override
    public void run() {
        this.active = true;
        try {
            InetAddress addr = InetAddress.getByName(this.serverBindAddr);
            this.datagramSocket = new DatagramSocket(this.udpPort, addr);
            this.udpSender = new UdpSender(this.datagramSocket);
            SoundCenter.logger.i("UDP-Server started on " + addr.getHostAddress() + ":" + this.udpPort + ".", null);
        }
        catch (SocketException e) {
            SoundCenter.logger.s("Error while starting UDP-Server on port" + this.udpPort, e);
            this.exit = true;
        }
        catch (UnknownHostException e) {
            SoundCenter.logger.s("Error while trying to resolve server-ip: " + this.serverBindAddr, e);
            this.exit = true;
        }
        while (!this.exit) {
            byte[] data = new byte[650];
            try {
                DatagramPacket receivedPacket = new DatagramPacket(data, data.length);
                this.datagramSocket.receive(receivedPacket);
                UdpPacket packet = new UdpPacket(receivedPacket.getData());
                if (packet.getIdent() != 19092) continue;
                ServerUser user = SoundCenter.userList.getAcceptedUserById(packet.getID());
                if (packet.getType() == 5 && SoundCenter.config.voiceEnabled()) {
                    if (user == null || !user.getIp().equals(receivedPacket.getAddress())) continue;
                    if (user.isSpeaking()) {
                        this.sendVoiceLocally(packet, user);
                        continue;
                    }
                    if (!user.isSpeakingGlobally()) continue;
                    this.sendVoiceGlobally(packet, user);
                    continue;
                }
                if (packet.getType() != 10 || user == null) continue;
                user.setUdpPort(receivedPacket.getPort());
            }
            catch (IOException e) {
                if (this.exit) continue;
                SoundCenter.logger.i("Error while receiving UDP-Packet:", e);
            }
        }
        if (!this.exit) {
            this.shutdown();
        }
        SoundCenter.userList.resetServerUsers();
        this.datagramSocket = null;
        this.active = false;
        SoundCenter.logger.i("UDP-Server was shut down!", null);
    }

    public void sendVoiceLocally(UdpPacket packet, ServerUser sourceUser) {
        this.udpSender.sendVoiceLocally(packet, sourceUser);
    }

    public void sendVoiceGlobally(UdpPacket packet, ServerUser sourceUser) {
        this.udpSender.sendVoiceGlobally(packet, sourceUser);
    }

    public void send(UdpPacket packet, ServerUser receptor) {
        this.udpSender.send(packet, receptor);
    }

    public void send(UdpPacket packet, List<ServerUser> receptors) {
        this.udpSender.send(packet, receptors);
    }

    public static long getTotalDataRate() {
        return totalVoiceDataRate + (long)(SoundCenter.userList.getInitializedUserCount() * 2160);
    }

    public void shutdown() {
        SoundCenter.logger.i("Shutting down UDP-Server...", null);
        this.exit = true;
        this.udpSender.shutdown();
        this.datagramSocket.close();
    }
}

