/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.network.udp;

import com.soundcenter.soundcenter.lib.udp.UdpPacket;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class UdpSender {
    private ExecutorService executor = null;
    private int nThreads = 1;
    private DatagramSocket datagramSocket = null;

    public UdpSender(DatagramSocket socket) {
        this.datagramSocket = socket;
        this.executor = Executors.newFixedThreadPool(this.nThreads);
    }

    public void send(UdpPacket packet, ServerUser receptor) {
        this.executor.execute(new Sender(packet, receptor));
    }

    public void send(UdpPacket packet, List<ServerUser> receptors) {
        this.executor.execute(new Sender(packet, receptors));
    }

    public void sendVoiceGlobally(UdpPacket packet, ServerUser sourceUser) {
        packet.setVolume((byte)100);
        ArrayList<ServerUser> receptorList = new ArrayList<ServerUser>();
        for (Map.Entry<Short, ServerUser> entry : SoundCenter.userList.acceptedUsers.entrySet()) {
            ServerUser user = entry.getValue();
            if (!user.isInitialized() || user.equals(sourceUser) || !user.isVoiceActive() || user.hasMuted(sourceUser.getId())) continue;
            receptorList.add(user);
        }
        this.executor.execute(new Sender(packet, receptorList));
    }

    public void sendVoiceLocally(UdpPacket packet, ServerUser sourceUser) {
        for (Map.Entry<ServerUser, Byte> entry : sourceUser.listeners.entrySet()) {
            ServerUser user = entry.getKey();
            if (!user.isInitialized() || !user.isVoiceActive() || user.hasMuted(sourceUser.getId())) continue;
            byte volume = entry.getValue();
            packet.setVolume(volume);
            this.executor.execute(new Sender(packet, user));
        }
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    private class Sender
    implements Runnable {
        private UdpPacket dataPacket;
        private List<ServerUser> receptors;
        private ServerUser singleReceptor;

        private Sender(UdpPacket dataPacket, List<ServerUser> receptors) {
            this.dataPacket = dataPacket;
            this.receptors = receptors;
        }

        private Sender(UdpPacket dataPacket, ServerUser user) {
            this.dataPacket = dataPacket;
            this.singleReceptor = user;
        }

        @Override
        public void run() {
            this.dataPacket.setIdent((short)19092);
            int receptorPort = 0;
            try {
                if (this.receptors != null) {
                    for (ServerUser user : this.receptors) {
                        receptorPort = user.getUdpPort();
                        if (receptorPort == 0) continue;
                        this.dataPacket.setDestUserID(user.getId());
                        this.dataPacket.setSeq(user.getSequenceNr());
                        user.incSequenceNr();
                        DatagramPacket packet = new DatagramPacket(this.dataPacket.getData(), this.dataPacket.getLength(), user.getIp(), receptorPort);
                        UdpSender.this.datagramSocket.send(packet);
                    }
                } else if (this.singleReceptor != null && (receptorPort = this.singleReceptor.getUdpPort()) != 0) {
                    this.dataPacket.setDestUserID(this.singleReceptor.getId());
                    this.dataPacket.setSeq(this.singleReceptor.getSequenceNr());
                    this.singleReceptor.incSequenceNr();
                    DatagramPacket packet = new DatagramPacket(this.dataPacket.getData(), this.dataPacket.getLength(), this.singleReceptor.getIp(), receptorPort);
                    UdpSender.this.datagramSocket.send(packet);
                }
            }
            catch (SecurityException e) {
                if (!SoundCenter.udpServer.exit) {
                    SoundCenter.logger.w("SecurityException while sending UDP-Packet:", e);
                }
                SoundCenter.udpServer.shutdown();
            }
            catch (IOException e) {
                if (!SoundCenter.udpServer.exit) {
                    SoundCenter.logger.i("Error while sending UDP-Packet:", e);
                }
                SoundCenter.udpServer.shutdown();
            }
        }
    }
}

