/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.network.tcp.protocol;

import com.soundcenter.soundcenter.lib.tcp.TcpPacket;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import com.soundcenter.soundcenter.plugin.network.tcp.protocol.CMDProtocol;
import com.soundcenter.soundcenter.plugin.network.tcp.protocol.DataProtocol;
import com.soundcenter.soundcenter.plugin.network.tcp.protocol.HandshakeProtocol;

public class MainProtocol {
    public static boolean processPacket(TcpPacket receivedPacket, ServerUser user) {
        Byte cmd = receivedPacket.getType();
        if (!user.isAccepted()) {
            return HandshakeProtocol.processPacket(cmd, receivedPacket, user);
        }
        if (!user.isInitialized()) {
            SoundCenter.tcpServer.send((byte)72, null, null, user);
            return true;
        }
        if (MainProtocol.isInGroup(cmd, (byte)-19, (byte)-10)) {
            return CMDProtocol.processPacket(cmd, receivedPacket, user);
        }
        if (MainProtocol.isInGroup(cmd, (byte)-39, (byte)-20)) {
            return DataProtocol.processPacket(cmd, receivedPacket, user);
        }
        if (cmd == -4) {
            user.setQuitReason("User quit.");
            return false;
        }
        return true;
    }

    private static boolean isInGroup(byte cmd, byte start, byte end) {
        return cmd >= start && cmd <= end;
    }
}

