/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.network.tcp.protocol;

import com.soundcenter.soundcenter.lib.tcp.TcpPacket;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import com.soundcenter.soundcenter.plugin.network.tcp.ConnectionManager;
import com.soundcenter.soundcenter.plugin.network.udp.UdpServer;
import java.util.Timer;
import java.util.TimerTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class HandshakeProtocol {
    public static boolean processPacket(byte cmd, TcpPacket receivedPacket, ServerUser user) {
        if (cmd == -1) {
            if (SoundCenter.userList.serverUserCount() >= SoundCenter.config.serverCapacity()) {
                SoundCenter.tcpServer.send((byte)7, null, null, user);
                user.setQuitReason("Server reached its full capacity.");
                return false;
            }
            if (UdpServer.getTotalDataRate() + 2160L > (long)(SoundCenter.config.maxBandwidth() * 1024)) {
                SoundCenter.tcpServer.send((byte)7, null, null, user);
                user.setQuitReason("Server has reached its bandwidth limit.");
                return false;
            }
            SoundCenter.tcpServer.send((byte)1, null, null, user);
            user.setJoinRequested(true);
            return true;
        }
        if (!user.hasJoinRequested()) {
            SoundCenter.tcpServer.send((byte)13, null, null, user);
            user.setQuitReason("Client not following the protocol.");
            return false;
        }
        if (cmd == -2) {
            Double version = (Double)receivedPacket.getKey();
            if (version >= 0.3 && version <= 0.399) {
                SoundCenter.tcpServer.send((byte)2, null, null, user);
                user.setVersionOK(true);
                return true;
            }
            SoundCenter.tcpServer.send((byte)8, 0.3, 0.399, user);
            user.setQuitReason("Wrong client version.");
            return false;
        }
        if (!user.isVersionOK()) {
            user.setQuitReason("Client not following the protocol.");
            SoundCenter.tcpServer.send((byte)13, null, null, user);
            return false;
        }
        if (cmd == -3) {
            final String name = (String)receivedPacket.getKey();
            if (name.length() <= 16) {
                if (SoundCenter.userList.getAcceptedUserByName(name) != null) {
                    SoundCenter.tcpServer.send((byte)10, null, null, user);
                    user.setQuitReason("User with name " + name + " is already connected.");
                    return false;
                }
                SoundCenter.tcpServer.send((byte)4, user.getId(), null, user);
                Thread.currentThread().setName("TcpUserConnection Name: " + name);
                user.setName(name);
                user.setNameOK(true);
                user.setAccepted(true);
                SoundCenter.userList.addAcceptedUser(user);
                SoundCenter.logger.d("User " + user.getIp() + " is connected to SoundCenter with id " + user.getId() + ".", null);
                final ServerUser joinedUser = user;
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (joinedUser.getUdpPort() == 0) {
                            SoundCenter.logger.d("Receiving no UDP-heartbeats from user " + name + " (" + joinedUser.getId() + ").", null);
                        }
                    }
                }, 20000L);
                Player player = Bukkit.getServer().getPlayer(name);
                if (player == null || !player.getName().equals(name) || !player.isOnline()) {
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (!joinedUser.isInitialized()) {
                                SoundCenter.tcpServer.send((byte)12, null, null, joinedUser);
                                joinedUser.setQuitReason("Initialization timeout.");
                                joinedUser.disconnect();
                            }
                        }
                    }, 120000L);
                    SoundCenter.tcpServer.send((byte)6, null, null, user);
                    return true;
                }
                return ConnectionManager.initialize(player);
            }
            SoundCenter.tcpServer.send((byte)9, null, null, user);
            user.setQuitReason("Invalid name.");
            return false;
        }
        if (!user.isNameOK()) {
            user.setQuitReason("Client not following the protocol.");
            SoundCenter.tcpServer.send((byte)13, null, null, user);
            return false;
        }
        SoundCenter.tcpServer.send((byte)73, null, null, user);
        return false;
    }
}

