/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.network.tcp.protocol;

import com.soundcenter.soundcenter.lib.data.GlobalConstants;
import com.soundcenter.soundcenter.lib.data.Song;
import com.soundcenter.soundcenter.lib.data.Station;
import com.soundcenter.soundcenter.lib.tcp.TcpPacket;
import com.soundcenter.soundcenter.lib.util.StringUtil;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;

public class DataProtocol {
    public static boolean processPacket(byte cmd, TcpPacket receivedPacket, ServerUser user) {
        if (cmd == -27) {
            Station newStation;
            short id;
            Player player = user.getPlayer();
            if (player == null) {
                SoundCenter.tcpServer.send((byte)73, "Could not get the Bukkit player instance.", null, user);
                return true;
            }
            byte by = (Byte)receivedPacket.getKey();
            Station oldStation = SoundCenter.database.getStation(by, id = (newStation = (Station)receivedPacket.getValue()).getId());
            if (oldStation == null || newStation == null || !oldStation.getOwner().equals(newStation.getOwner())) {
                SoundCenter.tcpServer.send((byte)73, "edit area", null, user);
                return true;
            }
            if (!(oldStation.getOwner().equals(user.getName()) || oldStation.isEditableByOthers() || player.hasPermission("sc.others.edit"))) {
                SoundCenter.tcpServer.send((byte)66, null, null, user);
                return true;
            }
            if (by == 0) {
                if (!oldStation.getMin().sameAs(newStation.getMin()) || !oldStation.getMax().sameAs(newStation.getMax())) {
                    SoundCenter.tcpServer.send((byte)73, "edit area", null, user);
                    return true;
                }
            } else if (by == 1) {
                if (oldStation == null || !oldStation.getLocation().sameAs(newStation.getLocation())) {
                    SoundCenter.tcpServer.send((byte)73, "edit box", null, user);
                    return true;
                }
                int maxRange = SoundCenter.config.maxBoxRange();
                if (newStation.getRange() > maxRange && maxRange > 0 && !player.hasPermission("sc.nolimits")) {
                    SoundCenter.tcpServer.send((byte)68, maxRange, null, null);
                    return true;
                }
            } else if (by == 4) {
                if (!oldStation.getName().equals(newStation.getName())) {
                    SoundCenter.tcpServer.send((byte)73, "edit wgregion", null, user);
                    return true;
                }
            } else if (by == 2) {
                if (!oldStation.getName().equals(newStation.getName())) {
                    SoundCenter.tcpServer.send((byte)73, "edit biome", null, user);
                    return true;
                }
            } else if (by == 3 && !oldStation.getName().equals(newStation.getName())) {
                SoundCenter.tcpServer.send((byte)73, "edit world", null, user);
                return true;
            }
            SoundCenter.database.addStation(by, newStation);
            SoundCenter.tcpServer.send((byte)30, newStation, null, null);
            return true;
        }
        if (cmd == -28) {
            short id;
            Player player = user.getPlayer();
            if (player == null) {
                SoundCenter.tcpServer.send((byte)73, "delete station", null, user);
                return true;
            }
            byte by = (Byte)receivedPacket.getKey();
            Station station = SoundCenter.database.getStation(by, id = ((Short)receivedPacket.getValue()).shortValue());
            if (station == null) {
                SoundCenter.tcpServer.send((byte)73, "delete station", null, user);
                return true;
            }
            if (station.getOwner().equals(user.getName()) || user.getPlayer().hasPermission("sc.others.delete")) {
                SoundCenter.database.removeStation(by, id);
                SoundCenter.tcpServer.send((byte)33, by, id, null);
            } else {
                SoundCenter.tcpServer.send((byte)67, null, null, user);
            }
            return true;
        }
        if (cmd == -26) {
            Station station;
            Player player = user.getPlayer();
            if (player == null) {
                SoundCenter.tcpServer.send((byte)73, "Could not get the Bukkit player instance.", null, user);
                return true;
            }
            byte by = (Byte)receivedPacket.getKey();
            if (SoundCenter.database.getStationByName(by, (station = (Station)receivedPacket.getValue()).getName()) != null) {
                SoundCenter.tcpServer.send((byte)70, "Station", null, user);
                return true;
            }
            String perm = "null";
            byte opcode = 30;
            if (by == 2) {
                perm = "sc.set.biome";
            } else if (by == 3) {
                perm = "sc.set.world";
            }
            if (player.hasPermission(perm)) {
                station.setOwner(player.getName());
                station.setId(SoundCenter.database.getAvailableId(by));
                SoundCenter.database.addStation(by, station);
                SoundCenter.tcpServer.send(opcode, station, null, null);
            } else {
                SoundCenter.tcpServer.send((byte)69, perm, null, user);
            }
            return true;
        }
        if (cmd == -29) {
            Player player = user.getPlayer();
            if (player == null) {
                SoundCenter.tcpServer.send((byte)73, "Could not get the Bukkit player instance.", null, user);
                return true;
            }
            Song song = (Song)receivedPacket.getKey();
            if (!player.hasPermission("sc.add.song")) {
                SoundCenter.tcpServer.send((byte)69, "sc.add.song", null, user);
                return true;
            }
            if (SoundCenter.database.getSong(song.getTitle()) != null) {
                SoundCenter.tcpServer.send((byte)70, "Song", null, user);
                return true;
            }
            song.setOwner(player.getName());
            SoundCenter.database.addSong(song);
            SoundCenter.tcpServer.send((byte)31, song, null, null);
            return true;
        }
        if (cmd == -30) {
            Player player = user.getPlayer();
            if (player == null) {
                SoundCenter.tcpServer.send((byte)73, "Could not get the Bukkit player instance.", null, user);
                return true;
            }
            Song song = (Song)receivedPacket.getKey();
            if (song.getOwner().equalsIgnoreCase(player.getName()) || player.hasPermission("sc.delete.others")) {
                SoundCenter.database.removeSong(song);
                SoundCenter.tcpServer.send((byte)34, song, null, null);
            } else {
                SoundCenter.tcpServer.send((byte)69, "sc.delete.others", null, user);
            }
            return true;
        }
        if (cmd == -20) {
            SoundCenter.tcpServer.send((byte)20, null, null, user);
            Player player = user.getPlayer();
            if (player == null) {
                SoundCenter.tcpServer.send((byte)73, "Could not get the Bukkit player instance.", null, user);
                return true;
            }
            Object[] objectArray = Biome.values();
            int perm = objectArray.length;
            int n = 0;
            while (n < perm) {
                Biome biome = objectArray[n];
                SoundCenter.tcpServer.send((byte)21, StringUtil.cutForUdp(biome.toString()), null, user);
                ++n;
            }
            for (World world : Bukkit.getServer().getWorlds()) {
                SoundCenter.tcpServer.send((byte)22, StringUtil.cutForUdp(world.getName()), null, user);
            }
            for (Map.Entry entry : SoundCenter.database.areas.entrySet()) {
                Station area = (Station)entry.getValue();
                SoundCenter.tcpServer.send((byte)30, area, null, user);
            }
            for (Map.Entry entry : SoundCenter.database.boxes.entrySet()) {
                Station box = (Station)entry.getValue();
                SoundCenter.tcpServer.send((byte)30, box, null, user);
            }
            if (SoundCenter.getWorldGuard() != null) {
                for (Map.Entry entry : SoundCenter.database.wgRegions.entrySet()) {
                    Station wgregion = (Station)entry.getValue();
                    SoundCenter.tcpServer.send((byte)30, wgregion, null, user);
                }
            }
            for (Map.Entry entry : SoundCenter.database.biomes.entrySet()) {
                Station biome = (Station)entry.getValue();
                SoundCenter.tcpServer.send((byte)30, biome, null, user);
            }
            for (Map.Entry entry : SoundCenter.database.worlds.entrySet()) {
                Station world = (Station)entry.getValue();
                SoundCenter.tcpServer.send((byte)30, world, null, user);
            }
            for (Map.Entry entry : SoundCenter.database.songs.entrySet()) {
                Song song = (Song)entry.getValue();
                SoundCenter.tcpServer.send((byte)31, song, null, user);
            }
            objectArray = GlobalConstants.permissions;
            int n2 = GlobalConstants.permissions.length;
            int n3 = 0;
            while (n3 < n2) {
                Biome biome = objectArray[n3];
                if (player.hasPermission((String)biome)) {
                    SoundCenter.tcpServer.send((byte)24, biome, null, user);
                }
                ++n3;
            }
            SoundCenter.tcpServer.send((byte)25, null, null, user);
            return true;
        }
        return true;
    }
}

