/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.network.tcp.protocol;

import com.soundcenter.soundcenter.lib.data.Song;
import com.soundcenter.soundcenter.lib.tcp.TcpPacket;
import com.soundcenter.soundcenter.plugin.PlaybackManager;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import com.soundcenter.soundcenter.plugin.messages.Messages;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class CMDProtocol {
    public static boolean processPacket(byte cmd, TcpPacket receivedPacket, ServerUser user) {
        if (cmd == -15) {
            user.setVoiceActive(false);
            Player player = user.getPlayer();
            if (player != null) {
                player.sendMessage(Messages.INFO_VOICE_MUTED);
            }
            return true;
        }
        if (cmd == -16) {
            user.setVoiceActive(true);
            Player player = user.getPlayer();
            if (player != null) {
                player.sendMessage(Messages.INFO_VOICE_UNMUTED);
            }
            return true;
        }
        if (cmd == -11) {
            Player player = user.getPlayer();
            if (player == null) {
                SoundCenter.tcpServer.send((byte)73, "Could not get the Bukkit player instance.", null, user);
                return true;
            }
            Song song = (Song)receivedPacket.getKey();
            String recipants = "";
            if (receivedPacket.getValue() != null) {
                recipants = (String)receivedPacket.getValue();
            }
            if (recipants.isEmpty()) {
                PlaybackManager.playSong(song, user);
                return true;
            }
            if (recipants.equals("/global")) {
                if (!player.hasPermission("sc.play.global")) {
                    SoundCenter.tcpServer.send((byte)65, "sc.play.global", null, user);
                    return true;
                }
                PlaybackManager.playGlobalSong(song);
                return true;
            }
            if (!player.hasPermission("sc.play.world")) {
                SoundCenter.tcpServer.send((byte)65, "sc.play.world", null, user);
                return true;
            }
            World world = Bukkit.getServer().getWorld(recipants);
            if (world == null) {
                SoundCenter.tcpServer.send((byte)71, "World: " + recipants, null, user);
                return true;
            }
            PlaybackManager.playWorldSong(song, world);
            return true;
        }
        if (cmd == -12) {
            Player player = user.getPlayer();
            if (player == null) {
                SoundCenter.tcpServer.send((byte)73, "Could not get the Bukkit player instance.", null, user);
                return true;
            }
            Song song = (Song)receivedPacket.getKey();
            String recipants = "";
            if (receivedPacket.getValue() != null) {
                recipants = (String)receivedPacket.getValue();
            }
            if (recipants.isEmpty()) {
                PlaybackManager.stopSong(song, user);
                return true;
            }
            if (recipants.equals("/global")) {
                if (!player.hasPermission("sc.play.global")) {
                    SoundCenter.tcpServer.send((byte)65, "sc.play.global", null, user);
                    return true;
                }
                PlaybackManager.stopGlobalSong(song);
                return true;
            }
            if (!player.hasPermission("sc.play.world")) {
                SoundCenter.tcpServer.send((byte)65, "sc.play.world", null, user);
                return true;
            }
            World world = Bukkit.getServer().getWorld(recipants);
            if (world == null) {
                SoundCenter.tcpServer.send((byte)71, "World: " + recipants, null, user);
                return true;
            }
            PlaybackManager.stopWorldSong(song, world);
            return true;
        }
        return true;
    }
}

