/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.network.tcp;

import com.soundcenter.soundcenter.lib.tcp.TcpPacket;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import com.soundcenter.soundcenter.plugin.messages.Messages;
import com.soundcenter.soundcenter.plugin.network.tcp.protocol.MainProtocol;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import org.bukkit.entity.Player;

public class TcpUserConnection
implements Runnable {
    private ServerUser user = null;

    public TcpUserConnection(Socket socket) {
        this.user = new ServerUser(socket);
        SoundCenter.userList.addConnectedUser(this.user);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("TcpUserConnection");
        ObjectOutputStream oos = this.user.getOos();
        ObjectInputStream ois = this.user.getOis();
        Socket socket = this.user.getSocket();
        while (!this.user.getDisconnect() && !socket.isClosed()) {
            try {
                Object receivedPacket = ois.readObject();
                if (!(receivedPacket instanceof TcpPacket) || MainProtocol.processPacket((TcpPacket)receivedPacket, this.user)) continue;
                break;
            }
            catch (IOException e) {
                if (!(SoundCenter.tcpServer.exit || this.user.getDisconnect() || socket.isClosed())) {
                    SoundCenter.logger.i("Lost connection to user " + this.user.getName() + " on " + this.user.getIp() + ".", e);
                }
                this.user.disconnect();
            }
            catch (ClassCastException e) {
                SoundCenter.logger.i("Error while restoring object from packet:", e);
                this.user.disconnect();
            }
            catch (ClassNotFoundException e) {
                SoundCenter.logger.i("Error while reading packet from user " + this.user.getName() + " on " + this.user.getIp() + ".", e);
                this.user.disconnect();
            }
        }
        SoundCenter.logger.i("Closed TCP-connection to user " + this.user.getName() + " on " + this.user.getIp() + ". \nReason: " + this.user.getQuitReason(), null);
        Player player = this.user.getPlayer();
        if (player != null) {
            player.sendMessage(Messages.ERR_CONNECTION_LOST);
        }
        this.user.disconnect();
        ArrayList<ServerUser> userList = new ArrayList<ServerUser>(SoundCenter.userList.acceptedUsers.values());
        for (ServerUser onlineUser : userList) {
            onlineUser.removeListener(this.user);
        }
        if (!SoundCenter.tcpServer.exit && oos != null) {
            SoundCenter.userList.removeServerUser(this.user);
        }
        if (!SoundCenter.tcpServer.exit && socket != null && !socket.isClosed()) {
            try {
                if (oos != null) {
                    oos.close();
                } else {
                    socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

