/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.network.tcp;

import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import com.soundcenter.soundcenter.plugin.network.tcp.TcpSender;
import com.soundcenter.soundcenter.plugin.network.tcp.TcpUserConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

public class TcpServer
implements Runnable {
    public boolean exit = false;
    public boolean active = false;
    public ServerSocket serverSocket = null;
    private TcpSender tcpSender = null;
    private Thread tcpSenderThread = null;
    private int tcpPort = 0;
    private String serverBindAddr = "";

    public TcpServer(int port, String serverIp) {
        this.tcpPort = port;
        this.serverBindAddr = serverIp;
    }

    @Override
    public void run() {
        this.active = true;
        try {
            InetAddress addr = InetAddress.getByName(this.serverBindAddr);
            this.serverSocket = new ServerSocket(this.tcpPort, 50, addr);
            this.tcpSender = new TcpSender();
            this.tcpSenderThread = new Thread(this.tcpSender);
            this.tcpSenderThread.start();
            SoundCenter.logger.i("TCP-Server started on " + addr.getHostAddress() + ":" + this.tcpPort + ".", null);
        }
        catch (UnknownHostException e) {
            SoundCenter.logger.s("Error while trying to resolve server-ip: " + this.serverBindAddr, e);
            this.exit = true;
        }
        catch (IOException e) {
            SoundCenter.logger.s("Error while starting TCP-Server on port " + this.tcpPort, e);
            this.exit = true;
        }
        while (!this.exit) {
            try {
                new Thread(new TcpUserConnection(this.serverSocket.accept())).start();
            }
            catch (IOException e) {
                if (this.exit) continue;
                SoundCenter.logger.i("Error while accepting new TCP-Connection:", e);
            }
        }
        if (!this.exit) {
            this.shutdown();
        }
        SoundCenter.userList.resetServerUsers();
        this.serverSocket = null;
        this.active = false;
        SoundCenter.logger.i("TCP-Server was shut down!", null);
    }

    public void shutdown() {
        SoundCenter.logger.i("Shutting down TCP-Server...", null);
        this.exit = true;
        if (this.tcpSenderThread != null) {
            this.tcpSenderThread.interrupt();
        }
        while (this.tcpSender.isActive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void send(Byte opCode, Object key, Object value, ServerUser user) {
        this.tcpSender.send(opCode, key, value, user);
    }
}

