/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.network.tcp;

import com.soundcenter.soundcenter.lib.tcp.TcpPacket;
import com.soundcenter.soundcenter.lib.tcp.TcpPacketContainer;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class TcpSender
implements Runnable {
    private BlockingQueue<TcpPacketContainer> container = new LinkedBlockingQueue<TcpPacketContainer>();
    private TcpPacketContainer cont = null;
    private TcpPacket packet = null;
    private ObjectOutputStream oos = null;
    private boolean active = true;

    @Override
    public void run() {
        this.active = true;
        Thread.currentThread().setName("TcpSender");
        while (!SoundCenter.tcpServer.exit) {
            try {
                this.cont = this.container.take();
                this.packet = this.cont.getPacket();
                this.oos = this.cont.getOos();
                if (this.packet == null) continue;
                try {
                    if (this.oos == null) {
                        for (ServerUser user : SoundCenter.userList.connectedUsers) {
                            this.oos = user.getOos();
                            if (this.oos == null) continue;
                            this.oos.writeObject(this.packet);
                        }
                        continue;
                    }
                    this.oos.writeObject(this.packet);
                }
                catch (IOException e) {
                    if (!SoundCenter.tcpServer.exit) continue;
                    SoundCenter.logger.d("Error while sending TCP-packet", e);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.packet = new TcpPacket((byte)3, null, null);
        for (ServerUser user : SoundCenter.userList.connectedUsers) {
            this.oos = user.getOos();
            try {
                this.oos.writeObject(this.packet);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.oos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            SoundCenter.tcpServer.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reset();
        this.active = false;
    }

    private void reset() {
        this.container.clear();
        this.cont = null;
        this.packet = null;
        this.oos = null;
    }

    private void addContainer(TcpPacketContainer cont) {
        this.container.add(cont);
    }

    public void send(Byte opCode, Object key, Object value, ServerUser user) {
        TcpPacket packet = new TcpPacket(opCode, key, value);
        ObjectOutputStream oos = null;
        if (user != null) {
            oos = user.getOos();
        }
        this.addContainer(new TcpPacketContainer(packet, oos));
    }

    public boolean isActive() {
        return this.active;
    }
}

