/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.network.tcp;

import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import com.soundcenter.soundcenter.plugin.messages.Messages;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ConnectionManager {
    public static boolean initialize(Player player) {
        ServerUser tcpUser = SoundCenter.userList.getAcceptedUserByName(player.getName());
        if (tcpUser != null) {
            if (player.hasPermission("sc.init") && tcpUser.isAccepted() && (tcpUser.getIp().equals(player.getAddress().getAddress()) || !SoundCenter.config.verifyIp())) {
                tcpUser.setInitialized(true);
                SoundCenter.userList.incrementInitializedUserCount();
                SoundCenter.tcpServer.send((byte)5, null, null, tcpUser);
                player.sendMessage(Messages.INFO_INIT_SUCCESS);
                return true;
            }
            if (!player.hasPermission("sc.init")) {
                player.sendMessage(Messages.ERR_PERMISSION_INIT);
                SoundCenter.tcpServer.send((byte)14, null, null, tcpUser);
                tcpUser.setQuitReason("Missing required permission: 'sc.init'");
                tcpUser.disconnect();
                return false;
            }
            if (tcpUser.isAccepted()) {
                SoundCenter.tcpServer.send((byte)11, null, null, tcpUser);
                player.sendMessage(Messages.ERR_IP_VERIFICATION);
                tcpUser.setQuitReason("IP-Verification failed.");
                tcpUser.disconnect();
                return false;
            }
            player.sendMessage(Messages.ERR_NOT_ACCEPTED);
            return true;
        }
        ConnectionManager.sendStartClientMessage(player);
        return true;
    }

    public static void sendStartClientMessage(Player player) {
        String ip = SoundCenter.config.serverIp();
        if (ip.isEmpty()) {
            ip = Bukkit.getServer().getIp();
        }
        player.sendMessage(String.valueOf(Messages.INFO_START_AUDIOCLIENT_PT1) + "http://sound-center.com?n=" + player.getName() + "&i=" + ip + "&p=" + SoundCenter.config.port() + "&v=" + 0.3 + " " + Messages.INFO_START_AUDIOCLIENT_PT2);
    }
}

