/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.data;

import com.soundcenter.soundcenter.plugin.data.ServerUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class UserList {
    public List<ServerUser> connectedUsers = Collections.synchronizedList(new ArrayList());
    public ConcurrentHashMap<Short, ServerUser> acceptedUsers = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Short> acceptedUsersName = new ConcurrentHashMap();
    private int initializedUserCount = 0;

    public void addConnectedUser(ServerUser user) {
        this.connectedUsers.add(user);
    }

    public void addAcceptedUser(ServerUser user) {
        short id = user.getId();
        this.acceptedUsersName.put(user.getName(), id);
        this.acceptedUsers.put(id, user);
    }

    public ServerUser getAcceptedUserByName(String name) {
        if (!this.acceptedUsersName.containsKey(name)) {
            return null;
        }
        short id = this.acceptedUsersName.get(name);
        return this.acceptedUsers.get(id);
    }

    public ServerUser getAcceptedUserById(Short id) {
        return this.acceptedUsers.get(id);
    }

    public int serverUserCount() {
        return this.connectedUsers.size();
    }

    public int getInitializedUserCount() {
        return this.initializedUserCount;
    }

    public void incrementInitializedUserCount() {
        ++this.initializedUserCount;
    }

    public void removeServerUser(ServerUser user) {
        this.connectedUsers.remove(user);
        if (user.isAccepted()) {
            this.acceptedUsersName.remove(user.getName());
            this.acceptedUsers.remove(user.getId());
            if (user.isInitialized()) {
                --this.initializedUserCount;
            }
        }
    }

    public void resetServerUsers() {
        this.connectedUsers.clear();
        this.acceptedUsersName.clear();
        this.acceptedUsers.clear();
    }

    public short getAvailableId() {
        Random rand = new Random();
        short id = (short)(rand.nextInt(Short.MAX_VALUE + Math.abs(Short.MIN_VALUE)) - Math.abs(Short.MIN_VALUE));
        if (id != 0 && !this.acceptedUsers.contains(id)) {
            return id;
        }
        return this.getAvailableId();
    }
}

