/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.data;

import com.soundcenter.soundcenter.plugin.SoundCenter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ServerUser {
    private Socket socket = null;
    private ObjectOutputStream oos = null;
    private ObjectInputStream ois = null;
    private InetAddress ip = null;
    private String name = null;
    private boolean disconnect = false;
    private boolean accepted = false;
    private boolean joinRequested = false;
    private boolean versionOK = false;
    private boolean nameOK = false;
    private boolean initialized = false;
    private String quitReason = "Unknown.";
    private int udpPort = 0;
    private short sequenceNr = Short.MIN_VALUE;
    private short id = 0;
    private boolean musicActive = true;
    private boolean voiceActive = true;
    private boolean speaking = false;
    private boolean speakingGlobally = false;
    private long speakingStartTime = 0L;
    public ConcurrentHashMap<ServerUser, Byte> listeners = new ConcurrentHashMap();
    private List<Short> mutedUsers = Collections.synchronizedList(new ArrayList());

    public ServerUser(Socket socket) {
        this.id = SoundCenter.userList.getAvailableId();
        this.socket = socket;
        if (socket != null) {
            this.ip = socket.getInetAddress();
            try {
                OutputStream out = socket.getOutputStream();
                InputStream in = socket.getInputStream();
                this.oos = new ObjectOutputStream(out);
                this.ois = new ObjectInputStream(in);
            }
            catch (IOException e) {
                SoundCenter.logger.d("Error while opening TCP-streams for user:" + this.ip + " (IP).", e);
                this.disconnect();
            }
        } else {
            SoundCenter.logger.d("Cannot establish TCP-connection to new user, due to invalid socket.", null);
            this.disconnect();
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public ObjectOutputStream getOos() {
        return this.oos;
    }

    public ObjectInputStream getOis() {
        return this.ois;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getDisconnect() {
        return this.disconnect;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(Boolean accepted) {
        this.accepted = accepted;
    }

    public boolean hasJoinRequested() {
        return this.joinRequested;
    }

    public void setJoinRequested(boolean joinRequested) {
        this.joinRequested = joinRequested;
    }

    public boolean isVersionOK() {
        return this.versionOK;
    }

    public void setVersionOK(boolean versionOK) {
        this.versionOK = versionOK;
    }

    public boolean isNameOK() {
        return this.nameOK;
    }

    public void setNameOK(boolean nameOK) {
        this.nameOK = nameOK;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getQuitReason() {
        return this.quitReason;
    }

    public void setQuitReason(String quitReason) {
        this.quitReason = quitReason;
    }

    public void disconnect() {
        SoundCenter.tcpServer.send((byte)3, "Disconnect by server.", null, this);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.disconnect = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public void setUdpPort(int value) {
        this.udpPort = value;
    }

    public short getSequenceNr() {
        return this.sequenceNr;
    }

    public void incSequenceNr() {
        this.sequenceNr = (short)(this.sequenceNr + 1);
    }

    public short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }

    public Player getPlayer() {
        if (this.name != null) {
            return Bukkit.getPlayer((String)this.name);
        }
        return null;
    }

    public boolean isMusicActive() {
        return this.musicActive;
    }

    public void setMusicActive(boolean value) {
        this.musicActive = value;
    }

    public boolean isVoiceActive() {
        return this.voiceActive;
    }

    public void setVoiceActive(boolean value) {
        this.voiceActive = value;
    }

    public boolean isSpeaking() {
        return this.speaking;
    }

    public void setSpeaking(boolean speaking) {
        this.speakingStartTime = System.currentTimeMillis();
        this.speaking = speaking;
    }

    public boolean isSpeakingGlobally() {
        return this.speakingGlobally;
    }

    public void setSpeakingGlobally(boolean speakingGlobally) {
        this.speakingStartTime = System.currentTimeMillis();
        this.speakingGlobally = speakingGlobally;
    }

    public long getSpeakingStartTime() {
        return this.speakingStartTime;
    }

    public void setSpeakingStartTime(long time) {
        this.speakingStartTime = time;
    }

    public void addListener(ServerUser user, byte volume) {
        this.listeners.put(user, volume);
    }

    public void removeListener(ServerUser user) {
        this.listeners.remove(user);
    }

    public void addMutedUser(short userId) {
        this.mutedUsers.add(userId);
    }

    public void removeMutedUser(short userId) {
        this.mutedUsers.remove(userId);
    }

    public boolean hasMuted(short userId) {
        return this.mutedUsers.contains(userId);
    }
}

