/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.data;

import com.soundcenter.soundcenter.lib.data.Area;
import com.soundcenter.soundcenter.lib.data.Box;
import com.soundcenter.soundcenter.lib.data.Song;
import com.soundcenter.soundcenter.lib.data.Station;
import com.soundcenter.soundcenter.lib.util.FileOperation;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class Database
implements Serializable {
    private static final long serialVersionUID = 4L;
    public ConcurrentHashMap<Short, Station> boxes = new ConcurrentHashMap();
    public ConcurrentHashMap<Short, Station> areas = new ConcurrentHashMap();
    public ConcurrentHashMap<Short, Station> biomes = new ConcurrentHashMap();
    public ConcurrentHashMap<Short, Station> worlds = new ConcurrentHashMap();
    public ConcurrentHashMap<Short, Station> wgRegions = new ConcurrentHashMap();
    public ConcurrentHashMap<String, Song> songs = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> boxCounts = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> areaCounts = new ConcurrentHashMap();

    public void addStation(byte type, Station station) {
        ConcurrentHashMap<Short, Station> map = this.getMap(type);
        if (map != null) {
            map.put(station.getId(), station);
            this.incrementCounter(station);
        }
        this.saveToDisk();
    }

    public Station getStation(byte type, short id) {
        Station station = null;
        ConcurrentHashMap<Short, Station> map = this.getMap(type);
        if (map != null) {
            station = map.get(id);
        }
        return station;
    }

    public Station getStationByName(byte type, String name) {
        ConcurrentHashMap<Short, Station> map = this.getMap(type);
        if (map != null) {
            for (Map.Entry<Short, Station> entry : map.entrySet()) {
                Station station = entry.getValue();
                if (!station.getName().equals(name)) continue;
                return station;
            }
        }
        return null;
    }

    public int getStationCount(byte type) {
        ConcurrentHashMap<Short, Station> map = this.getMap(type);
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    public int getStationCount(byte type, String player) {
        int count = 0;
        ConcurrentHashMap<Short, Station> map = this.getMap(type);
        if (map != null) {
            for (Map.Entry<Short, Station> entry : map.entrySet()) {
                Station station = entry.getValue();
                if (!station.getOwner().equals(player)) continue;
                ++count;
            }
        }
        return count;
    }

    public Station removeStation(byte type, short id) {
        Station station = null;
        ConcurrentHashMap<Short, Station> map = this.getMap(type);
        if (map != null && (station = map.remove(id)) != null) {
            this.decrementCounter(station);
        }
        this.saveToDisk();
        return station;
    }

    public void removeStation(Station station) {
        this.removeStation(station.getType(), station.getId());
    }

    public short getAvailableId(byte type) {
        ConcurrentHashMap<Short, Station> map = this.getMap(type);
        if (map != null) {
            Random rand = new Random();
            short id = (short)(rand.nextInt(Short.MAX_VALUE + Math.abs(Short.MIN_VALUE)) - Math.abs(Short.MIN_VALUE));
            if (map.get(id) == null && id != 0) {
                return id;
            }
            return this.getAvailableId(type);
        }
        return 0;
    }

    public Song getSong(String title) {
        return this.songs.get(title);
    }

    public void addSong(Song song) {
        this.songs.put(song.getTitle(), song);
        this.saveToDisk();
    }

    public void removeSong(Song song) {
        this.songs.remove(song.getTitle());
        for (Map.Entry<Short, Station> entry : this.areas.entrySet()) {
            entry.getValue().removeSong(song);
        }
        for (Map.Entry<Short, Station> entry : this.boxes.entrySet()) {
            entry.getValue().removeSong(song);
        }
        for (Map.Entry<Short, Station> entry : this.biomes.entrySet()) {
            entry.getValue().removeSong(song);
        }
        for (Map.Entry<Short, Station> entry : this.worlds.entrySet()) {
            entry.getValue().removeSong(song);
        }
        for (Map.Entry<Short, Station> entry : this.wgRegions.entrySet()) {
            entry.getValue().removeSong(song);
        }
        this.saveToDisk();
    }

    private void incrementCounter(Station station) {
        ConcurrentHashMap<String, Integer> map = null;
        if (station instanceof Area) {
            map = this.areaCounts;
        } else if (station instanceof Box) {
            map = this.boxCounts;
        }
        if (map != null) {
            String owner = station.getOwner();
            int count = 0;
            if (map.containsKey(owner)) {
                count = map.get(owner);
            }
            map.put(owner, ++count);
        }
    }

    private void decrementCounter(Station station) {
        ConcurrentHashMap<String, Integer> map = null;
        if (station instanceof Area) {
            map = this.areaCounts;
        } else if (station instanceof Box) {
            map = this.boxCounts;
        }
        if (map != null) {
            String owner = station.getOwner();
            int count = 0;
            if (map.containsKey(owner)) {
                count = map.get(owner);
            }
            if (count > 0) {
                map.put(owner, --count);
            }
        }
    }

    private ConcurrentHashMap<Short, Station> getMap(byte type) {
        switch (type) {
            case 0: {
                return this.areas;
            }
            case 1: {
                return this.boxes;
            }
            case 2: {
                return this.biomes;
            }
            case 3: {
                return this.worlds;
            }
            case 4: {
                return this.wgRegions;
            }
        }
        return null;
    }

    private void saveToDisk() {
        try {
            FileOperation.saveObject(SoundCenter.dataFile, this);
        }
        catch (IOException e) {
            SoundCenter.logger.w("Error while saving data.", e);
        }
    }

    public void readObject(ObjectInputStream stream) throws InvalidClassException, ClassNotFoundException, IOException {
        stream.defaultReadObject();
        if (this.areas == null) {
            this.areas = new ConcurrentHashMap();
        }
        if (this.boxes == null) {
            this.boxes = new ConcurrentHashMap();
        }
        if (this.biomes == null) {
            this.biomes = new ConcurrentHashMap();
        }
        if (this.worlds == null) {
            this.worlds = new ConcurrentHashMap();
        }
        if (this.wgRegions == null) {
            this.wgRegions = new ConcurrentHashMap();
        }
        if (this.songs == null) {
            this.songs = new ConcurrentHashMap();
        }
        if (this.boxCounts == null) {
            this.boxCounts = new ConcurrentHashMap();
        }
        if (this.areaCounts == null) {
            this.areaCounts = new ConcurrentHashMap();
        }
    }
}

