/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin.commands;

import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.soundcenter.soundcenter.lib.data.Area;
import com.soundcenter.soundcenter.lib.data.Box;
import com.soundcenter.soundcenter.lib.data.SCLocation;
import com.soundcenter.soundcenter.lib.data.SCLocation2D;
import com.soundcenter.soundcenter.lib.data.Song;
import com.soundcenter.soundcenter.lib.data.Station;
import com.soundcenter.soundcenter.lib.data.WGRegion;
import com.soundcenter.soundcenter.plugin.PlaybackManager;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import com.soundcenter.soundcenter.plugin.messages.Messages;
import com.soundcenter.soundcenter.plugin.network.tcp.ConnectionManager;
import com.soundcenter.soundcenter.plugin.network.udp.UdpServer;
import com.soundcenter.soundcenter.plugin.util.IntersectionDetection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SCCommandExecutor
implements CommandExecutor {
    private SoundCenter plugin;

    public SCCommandExecutor(SoundCenter plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player player = null;
        if (args.length < 1) {
            return false;
        }
        if (args[0].equalsIgnoreCase("help")) {
            int page = 1;
            if (args.length >= 2) {
                try {
                    page = Integer.valueOf(args[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sender.sendMessage(Messages.INFO_HELP_TITLE);
            int i = (page - 1) * 7;
            while (i < (page - 1) * 7 + 7) {
                if (i >= Messages.INFO_HELP_COMMANDS.length) break;
                sender.sendMessage(Messages.INFO_HELP_COMMANDS[i]);
                ++i;
            }
            sender.sendMessage(String.valueOf(Messages.INFO_HELP_PAGE_PT1) + (page + 1) + Messages.INFO_HELP_PAGE_PT2);
            return true;
        }
        if (args[0].equalsIgnoreCase("users")) {
            if (!sender.hasPermission("sc.init")) {
                sender.sendMessage(Messages.ERR_PERMISSION_INIT);
                return true;
            }
            int numUsers = 0;
            String users = ". ";
            for (Map.Entry<Short, ServerUser> entry : SoundCenter.userList.acceptedUsers.entrySet()) {
                ServerUser user = entry.getValue();
                if (!user.isInitialized()) continue;
                if (numUsers > 0) {
                    users.concat(", ");
                }
                users.concat(user.getName());
                ++numUsers;
            }
            sender.sendMessage(String.valueOf(Messages.INFO_USERS) + numUsers + users);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(Messages.ERR_SENDER_NO_PLAYER);
            return true;
        }
        player = (Player)sender;
        if (args[0].equalsIgnoreCase("init")) {
            ConnectionManager.initialize(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("mute")) {
            ServerUser user = SoundCenter.userList.getAcceptedUserByName(player.getName());
            if (user == null || !user.isInitialized()) {
                ConnectionManager.sendStartClientMessage(player);
                return true;
            }
            if (args.length > 1) {
                ServerUser userToMute = SoundCenter.userList.getAcceptedUserByName(args[1]);
                if (userToMute == null) {
                    player.sendMessage(String.valueOf(Messages.ERR_MUTE_PT1) + args[1] + " because he is not using the audio-client.");
                    return true;
                }
                user.addMutedUser(userToMute.getId());
                player.sendMessage(String.valueOf(Messages.INFO_USER_MUTED) + args[1]);
            }
            player.sendMessage(Messages.CMD_USAGE_MUTE);
        } else if (args[0].equalsIgnoreCase("unmute")) {
            ServerUser user = SoundCenter.userList.getAcceptedUserByName(player.getName());
            if (user == null || !user.isInitialized()) {
                ConnectionManager.sendStartClientMessage(player);
                return true;
            }
            if (args.length > 1) {
                ServerUser userToUnmute = SoundCenter.userList.getAcceptedUserByName(args[1]);
                if (userToUnmute == null) {
                    player.sendMessage(String.valueOf(Messages.ERR_MUTE_PT1) + args[1] + " because he is not using the audio-client.");
                    return true;
                }
                user.removeMutedUser(userToUnmute.getId());
                player.sendMessage(String.valueOf(Messages.INFO_USER_UNMUTED) + args[1]);
            }
            player.sendMessage(Messages.CMD_USAGE_UNMUTE);
        } else {
            if (args[0].equalsIgnoreCase("toggle")) {
                ServerUser user = SoundCenter.userList.getAcceptedUserByName(player.getName());
                if (user == null || !user.isInitialized()) {
                    ConnectionManager.sendStartClientMessage(player);
                    return true;
                }
                if (args.length > 1) {
                    if (args[1].equalsIgnoreCase("music")) {
                        user.setMusicActive(!user.isMusicActive());
                        if (user.isMusicActive()) {
                            SoundCenter.tcpServer.send((byte)44, null, null, user);
                            player.sendMessage(Messages.INFO_MUSIC_UNMUTED);
                        } else {
                            SoundCenter.tcpServer.send((byte)43, null, null, user);
                            player.sendMessage(Messages.INFO_MUSIC_MUTED);
                        }
                        return true;
                    }
                    if (args[1].equalsIgnoreCase("voice")) {
                        user.setVoiceActive(!user.isVoiceActive());
                        if (user.isVoiceActive()) {
                            SoundCenter.tcpServer.send((byte)46, null, null, user);
                            player.sendMessage(Messages.INFO_VOICE_UNMUTED);
                        } else {
                            SoundCenter.tcpServer.send((byte)45, null, null, user);
                            player.sendMessage(Messages.INFO_VOICE_MUTED);
                        }
                        return true;
                    }
                }
                player.sendMessage(Messages.CMD_USAGE_TOGGLE);
                return true;
            }
            if (args[0].equalsIgnoreCase("volume")) {
                if (args.length > 1) {
                    ServerUser user = SoundCenter.userList.getAcceptedUserByName(player.getName());
                    if (user == null || !user.isInitialized()) {
                        ConnectionManager.sendStartClientMessage(player);
                        return true;
                    }
                    try {
                        int volume = Integer.parseInt(args[1]);
                        if (volume > 0 && volume <= 100) {
                            SoundCenter.tcpServer.send((byte)42, (byte)volume, null, user);
                            player.sendMessage(String.valueOf(Messages.INFO_VOLUME_CHANGED) + volume + " %.");
                            return true;
                        }
                    }
                    catch (NumberFormatException volume) {
                        // empty catch block
                    }
                }
                player.sendMessage(Messages.CMD_USAGE_VOLUME);
                return true;
            }
            if (args[0].equalsIgnoreCase("status")) {
                SCLocation loc = new SCLocation(player.getLocation());
                HashMap<Short, Double> boxes = IntersectionDetection.inRangeOfBox(loc);
                HashMap<Short, Double> areas = IntersectionDetection.isInArea(loc);
                ArrayList<WGRegion> wgRegions = new ArrayList<WGRegion>();
                for (Map.Entry<Short, Station> entry : SoundCenter.database.wgRegions.entrySet()) {
                    ProtectedRegion region = SoundCenter.getWorldGuard().getRegionManager(player.getWorld()).getRegion(entry.getValue().getName());
                    if (!region.contains(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ())) continue;
                    wgRegions.add((WGRegion)entry.getValue());
                }
                player.sendMessage(String.valueOf(Messages.prefix) + "You are in range of " + boxes.size() + " boxes:");
                for (Map.Entry<Short, Object> entry : boxes.entrySet()) {
                    Box box = (Box)SoundCenter.database.getStation((byte)1, entry.getKey());
                    if (box == null) continue;
                    player.sendMessage(String.valueOf(Messages.prefix) + "- ID: " + box.getId() + ", owner: " + box.getOwner() + ", distance: " + Math.round((Double)entry.getValue()));
                }
                player.sendMessage(String.valueOf(Messages.prefix) + "You are located in " + areas.size() + " areas:");
                for (Map.Entry<Short, Object> entry : areas.entrySet()) {
                    Area area = (Area)SoundCenter.database.getStation((byte)0, entry.getKey());
                    if (area == null) continue;
                    player.sendMessage(String.valueOf(Messages.prefix) + "- ID: " + area.getId() + ", owner: " + area.getOwner() + ", distance to border: " + Math.round((Double)entry.getValue()));
                }
                player.sendMessage(String.valueOf(Messages.prefix) + "You are located in " + wgRegions.size() + " WorldGuard regions:");
                for (WGRegion wGRegion : wgRegions) {
                    player.sendMessage(String.valueOf(Messages.prefix) + "- Name: " + wGRegion.getName() + ", owner: " + wGRegion.getOwner());
                }
                String string = player.getWorld().getBiome(player.getLocation().getBlockX(), player.getLocation().getBlockZ()).toString();
                for (Map.Entry<Short, Station> entry : SoundCenter.database.biomes.entrySet()) {
                    if (!entry.getValue().getName().equalsIgnoreCase(string)) continue;
                    player.sendMessage(String.valueOf(Messages.prefix) + "You are in biome: ");
                }
                for (Map.Entry<Short, Station> entry : SoundCenter.database.worlds.entrySet()) {
                    if (!entry.getValue().getName().equalsIgnoreCase(player.getWorld().getName())) continue;
                    player.sendMessage(String.valueOf(Messages.prefix) + "You are in world: ");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("play")) {
                if (args.length >= 2) {
                    String title = "";
                    int nextParamIndex = 2;
                    if (args[1].startsWith("\"")) {
                        title = args[1].substring(1);
                        int i = 2;
                        while (i < args.length) {
                            if (args[i].endsWith("")) {
                                title = args[i].substring(0, args[i].length() - 2);
                                nextParamIndex = i++;
                                break;
                            }
                            title = String.valueOf(title) + args[i];
                            ++i;
                        }
                    } else {
                        title = args[1];
                    }
                    Song song = SoundCenter.database.getSong(title);
                    if (song == null) {
                        player.sendMessage(Messages.ERR_SONG_NOT_EXISTANT);
                        return true;
                    }
                    if (args.length < nextParamIndex + 1) {
                        PlaybackManager.playSong(song, SoundCenter.userList.getAcceptedUserByName(player.getName()));
                        player.sendMessage(String.valueOf(Messages.INFO_PLAYING_SONG) + song.getTitle());
                        return true;
                    }
                    if (args[nextParamIndex].equalsIgnoreCase("global")) {
                        if (!player.hasPermission("sc.play.global")) {
                            player.sendMessage(Messages.ERR_PERMISSION_PLAY_GLOBAL);
                            return true;
                        }
                        PlaybackManager.playGlobalSong(song);
                        player.sendMessage(String.valueOf(Messages.INFO_PLAYING_SONG) + song.getTitle() + " for everyone on the server.");
                        return true;
                    }
                    if (args[nextParamIndex].equalsIgnoreCase("world")) {
                        if (!player.hasPermission("sc.play.world")) {
                            player.sendMessage(Messages.ERR_PERMISSION_PLAY_WORLD);
                            return true;
                        }
                        if (args.length >= nextParamIndex + 2) {
                            String worldName = args[nextParamIndex + 1];
                            World world = Bukkit.getServer().getWorld(worldName);
                            if (world == null) {
                                player.sendMessage(Messages.ERR_WORLD_NOT_EXISTANT);
                                return true;
                            }
                            PlaybackManager.playWorldSong(song, world);
                            player.sendMessage(String.valueOf(Messages.INFO_PLAYING_SONG) + song.getTitle() + " in world: " + world.getName());
                            return true;
                        }
                    }
                }
                player.sendMessage(Messages.CMD_USAGE_PLAY);
                return true;
            }
            if (args[0].equalsIgnoreCase("stop")) {
                if (args.length >= 2) {
                    String title = "";
                    int nextParamIndex = 2;
                    if (args[1].startsWith("\"")) {
                        title = args[1].substring(1);
                        int i = 2;
                        while (i < args.length) {
                            if (args[i].endsWith("")) {
                                title = args[i].substring(0, args[i].length() - 2);
                                nextParamIndex = i++;
                                break;
                            }
                            title = String.valueOf(title) + args[i];
                            ++i;
                        }
                    } else {
                        title = args[1];
                    }
                    Song song = SoundCenter.database.getSong(title);
                    if (song == null) {
                        player.sendMessage(Messages.ERR_SONG_NOT_EXISTANT);
                        return true;
                    }
                    if (args.length < nextParamIndex + 1) {
                        PlaybackManager.stopSong(song, SoundCenter.userList.getAcceptedUserByName(player.getName()));
                        player.sendMessage(String.valueOf(Messages.INFO_STOPPED_SONG) + song.getTitle());
                        return true;
                    }
                    if (args[nextParamIndex].equalsIgnoreCase("global")) {
                        if (!player.hasPermission("sc.play.global")) {
                            player.sendMessage(Messages.ERR_PERMISSION_PLAY_GLOBAL);
                            return true;
                        }
                        PlaybackManager.stopGlobalSong(song);
                        player.sendMessage(String.valueOf(Messages.INFO_STOPPED_SONG) + song.getTitle() + " for everyone on the server.");
                        return true;
                    }
                    if (args[nextParamIndex].equalsIgnoreCase("world")) {
                        if (!player.hasPermission("sc.play.world")) {
                            player.sendMessage(Messages.ERR_PERMISSION_PLAY_WORLD);
                            return true;
                        }
                        if (args.length >= nextParamIndex + 2) {
                            String worldName = args[nextParamIndex + 1];
                            World world = Bukkit.getServer().getWorld(worldName);
                            if (world == null) {
                                player.sendMessage(Messages.ERR_WORLD_NOT_EXISTANT);
                                return true;
                            }
                            PlaybackManager.stopWorldSong(song, world);
                            player.sendMessage(String.valueOf(Messages.INFO_STOPPED_SONG) + song.getTitle() + " in world: " + world.getName());
                            return true;
                        }
                    }
                }
                player.sendMessage(Messages.CMD_USAGE_STOP);
                return true;
            }
            if (args[0].equalsIgnoreCase("set")) {
                if (args.length >= 2 && args[1].equalsIgnoreCase("area")) {
                    if (!player.hasPermission("sc.set.area")) {
                        player.sendMessage(Messages.ERR_PERMISSION_SET_AREA);
                        return true;
                    }
                    int maxAreas = SoundCenter.config.maxAreas();
                    if (maxAreas > 0 && SoundCenter.database.getStationCount((byte)0, player.getName()) >= maxAreas && !player.hasPermission("sc.nolimits")) {
                        player.sendMessage(String.valueOf(Messages.ERR_MAX_AREAS) + maxAreas + ChatColor.RED + "areas.");
                        return true;
                    }
                    Location corner0 = (Location)this.getMetadata(player, "com.github.wegfetz.custommusic.corner0", (Plugin)this.plugin);
                    Location corner1 = (Location)this.getMetadata(player, "com.github.wegfetz.custommusic.corner1", (Plugin)this.plugin);
                    if (corner0 == null || corner1 == null) {
                        player.sendMessage(Messages.ERR_NO_CORNERS);
                        return true;
                    }
                    Area newArea = new Area(SoundCenter.database.getAvailableId((byte)0), player.getName(), new SCLocation(corner0), new SCLocation(corner1), SoundCenter.config.defaultFadeout());
                    if (IntersectionDetection.areaOverlaps(newArea) && !player.hasPermission("sc.set.overlap")) {
                        player.sendMessage(Messages.ERR_PERMISSION_SET_OVERLAP);
                        return true;
                    }
                    player.removeMetadata("com.github.wegfetz.custommusic.corner0", (Plugin)this.plugin);
                    player.removeMetadata("com.github.wegfetz.custommusic.corner1", (Plugin)this.plugin);
                    SoundCenter.database.addStation((byte)0, newArea);
                    player.sendMessage(String.valueOf(Messages.INFO_AREA_CREATED) + newArea.getId());
                    SoundCenter.tcpServer.send((byte)30, newArea, null, null);
                    return true;
                }
                if (args.length >= 2 && args[1].equalsIgnoreCase("box")) {
                    Box newBox;
                    if (!player.hasPermission("sc.set.box")) {
                        player.sendMessage(Messages.ERR_PERMISSION_SET_BOX);
                        return true;
                    }
                    int maxBoxes = SoundCenter.config.maxBoxes();
                    if (maxBoxes > 0 && SoundCenter.database.getStationCount((byte)1, player.getName()) >= maxBoxes && !player.hasPermission("sc.nolimits")) {
                        player.sendMessage(String.valueOf(Messages.ERR_MAX_BOXES) + maxBoxes + ChatColor.RED + "boxes.");
                        return true;
                    }
                    int radius = SoundCenter.config.defaultBoxRange();
                    if (args.length >= 3) {
                        try {
                            radius = Integer.parseInt(args[2]);
                        }
                        catch (NumberFormatException corner1) {
                            // empty catch block
                        }
                    }
                    int maxRange = SoundCenter.config.maxBoxRange();
                    if (radius <= 0) {
                        player.sendMessage(Messages.ERR_MIN_BOX_RANGE);
                        radius = SoundCenter.config.defaultBoxRange();
                    }
                    if (radius > maxRange && maxRange > 0 && !player.hasPermission("sc.nolimits")) {
                        player.sendMessage(String.valueOf(Messages.ERR_MAX_BOX_RANGE) + maxRange);
                        radius = maxRange;
                    }
                    if (IntersectionDetection.boxOverlaps(newBox = new Box(SoundCenter.database.getAvailableId((byte)1), player.getName(), new SCLocation(player.getLocation()), radius)) && !player.hasPermission("sc.set.overlap")) {
                        player.sendMessage(Messages.ERR_PERMISSION_SET_OVERLAP);
                        return true;
                    }
                    SoundCenter.database.addStation((byte)1, newBox);
                    player.sendMessage(String.valueOf(Messages.INFO_BOX_CREATED) + newBox.getId());
                    SoundCenter.tcpServer.send((byte)30, newBox, null, null);
                    return true;
                }
                if (args.length >= 2 && args[1].equalsIgnoreCase("wgregion")) {
                    if (SoundCenter.getWorldGuard() == null) {
                        player.sendMessage(Messages.ERR_LOAD_WORLDGUARD);
                        return true;
                    }
                    if (!player.hasPermission("sc.set.wgregion")) {
                        player.sendMessage(Messages.ERR_PERMISSION_SET_WGREGION);
                        return true;
                    }
                    if (args.length >= 3) {
                        ProtectedRegion region = SoundCenter.getWorldGuard().getRegionManager(player.getWorld()).getRegion(args[2]);
                        if (region == null) {
                            player.sendMessage(Messages.ERR_WGREGION_NOT_EXISTANT);
                            return true;
                        }
                        for (Map.Entry<Short, Station> entry : SoundCenter.database.wgRegions.entrySet()) {
                            if (!entry.getValue().getName().equalsIgnoreCase(args[2])) continue;
                            player.sendMessage(Messages.ERR_WGREGION_ALREADY_EXISTANT);
                            return true;
                        }
                        LocalPlayer lPlayer = SoundCenter.getWorldGuard().wrapPlayer(player);
                        if (!region.isMember(lPlayer) && !player.hasPermission("sc.set.wgregion.nomember")) {
                            player.sendMessage(Messages.ERR_PERMISSION_SET_WGREGION_OTHERS);
                            return true;
                        }
                        ArrayList<SCLocation2D> points = new ArrayList<SCLocation2D>();
                        for (BlockVector2D point : region.getPoints()) {
                            points.add(new SCLocation2D(point.getX(), point.getZ(), player.getWorld().getName()));
                        }
                        SCLocation min = new SCLocation(region.getMinimumPoint().getX(), region.getMinimumPoint().getY(), region.getMinimumPoint().getZ(), player.getWorld().getName(), "null");
                        SCLocation sCLocation = new SCLocation(region.getMaximumPoint().getX(), region.getMaximumPoint().getY(), region.getMaximumPoint().getZ(), player.getWorld().getName(), "null");
                        WGRegion newRegion = new WGRegion(SoundCenter.database.getAvailableId((byte)4), player.getName(), args[2], min, sCLocation, points);
                        SoundCenter.database.addStation((byte)4, newRegion);
                        player.sendMessage(String.valueOf(Messages.INFO_WGREGION_CREATED) + newRegion.getId());
                        SoundCenter.tcpServer.send((byte)30, newRegion, null, null);
                        return true;
                    }
                    player.sendMessage(Messages.CMD_USAGE_SET_WGREGION);
                    return true;
                }
                if (args.length >= 2 && args[1].equalsIgnoreCase("corner")) {
                    if (!player.hasPermission("sc.set.area")) {
                        player.sendMessage(Messages.ERR_PERMISSION_SET_AREA);
                        return true;
                    }
                    if (args.length >= 3 && (args[2].equalsIgnoreCase("1") || args[2].equalsIgnoreCase("2"))) {
                        int arg = 0;
                        int b = 1;
                        if (args[2].equalsIgnoreCase("2")) {
                            arg = 1;
                            b = 0;
                        }
                        Location loc = player.getLocation();
                        Location otherCorner = (Location)this.getMetadata(player, "com.github.wegfetz.custommusic.corner" + b, (Plugin)this.plugin);
                        if (otherCorner != null) {
                            if (!otherCorner.getWorld().equals(loc.getWorld())) {
                                player.sendMessage(Messages.ERR_CORNERS_DIFFERENT_WORLDS);
                                return true;
                            }
                            int n = SoundCenter.config.maxAreaSize();
                            if (!(n <= 0 || player.hasPermission("sc.nolimits") || n >= Math.abs(loc.getBlockX() - otherCorner.getBlockX()) && n >= Math.abs(loc.getBlockY() - otherCorner.getBlockY()) && n >= Math.abs(loc.getBlockZ() - otherCorner.getBlockZ()))) {
                                player.sendMessage(String.valueOf(Messages.ERR_MAX_AREA_SIZE) + n);
                                return true;
                            }
                            if (otherCorner.getBlockX() == loc.getBlockX() || otherCorner.getBlockY() == loc.getBlockY() || otherCorner.getBlockZ() == loc.getBlockZ()) {
                                sender.sendMessage(Messages.ERR_CORNERS_IN_LINE);
                                return true;
                            }
                        }
                        this.setMetadata(player, "com.github.wegfetz.custommusic.corner" + arg, loc, (Plugin)this.plugin);
                        player.sendMessage(String.valueOf(Messages.prefix) + ChatColor.GREEN + "Corner " + (arg + 1) + " set.");
                        return true;
                    }
                    player.sendMessage(Messages.CMD_USAGE_SET_CORNERS);
                    return true;
                }
                player.sendMessage(Messages.CMD_USAGE_SET);
                return true;
            }
            if (args[0].equalsIgnoreCase("speak")) {
                if (!SoundCenter.config.voiceEnabled()) {
                    player.sendMessage(Messages.ERR_VOICE_CHAT_DISABLED);
                    return true;
                }
                if (!player.hasPermission("sc.speak")) {
                    player.sendMessage(Messages.ERR_PERMISSION_SPEAK);
                    return true;
                }
                ServerUser user = SoundCenter.userList.getAcceptedUserByName(player.getName());
                if (user == null || !user.isInitialized()) {
                    ConnectionManager.sendStartClientMessage(player);
                    return true;
                }
                if (args.length >= 2 && args[1].equalsIgnoreCase("global")) {
                    if (!player.hasPermission("sc.speak.global")) {
                        player.sendMessage(Messages.ERR_PERMISSION_SPEAK_GLOBAL);
                        return true;
                    }
                    if (!user.isSpeaking() && !user.isSpeakingGlobally()) {
                        user.setSpeakingGlobally(true);
                        if ((double)UdpServer.getTotalDataRate() + (double)(4000 * SoundCenter.userList.acceptedUsers.size()) * 0.8 <= (double)(SoundCenter.config.maxBandwidth() * 1024)) {
                            SoundCenter.tcpServer.send((byte)40, null, null, user);
                            UdpServer.totalVoiceDataRate = (long)((double)UdpServer.totalVoiceDataRate + (double)(4000 * SoundCenter.userList.acceptedUsers.size()) * 0.8);
                            player.sendMessage(Messages.INFO_SPEAKING_GLOBALLY);
                        } else {
                            player.sendMessage(Messages.ERR_SERVER_LOAD);
                            user.setSpeaking(false);
                        }
                    } else {
                        UdpServer.totalVoiceDataRate = user.isSpeakingGlobally() ? (long)((double)UdpServer.totalVoiceDataRate - (double)(4000 * SoundCenter.userList.acceptedUsers.size()) * 0.8) : (UdpServer.totalVoiceDataRate -= (long)(4000 * user.listeners.size()));
                        user.setSpeaking(false);
                        user.setSpeakingGlobally(false);
                        SoundCenter.tcpServer.send((byte)41, null, null, user);
                        player.sendMessage(Messages.INFO_NOT_SPEAKING);
                    }
                    return true;
                }
                if (!user.isSpeaking() && !user.isSpeakingGlobally()) {
                    user.setSpeaking(true);
                    if (UdpServer.getTotalDataRate() + (long)(4000 * user.listeners.size()) <= (long)(SoundCenter.config.maxBandwidth() * 1024)) {
                        UdpServer.totalVoiceDataRate += (long)(4000 * user.listeners.size());
                        SoundCenter.tcpServer.send((byte)40, null, null, user);
                        player.sendMessage(Messages.INFO_SPEAKING);
                    } else {
                        player.sendMessage(Messages.ERR_SERVER_LOAD);
                        user.setSpeaking(false);
                    }
                } else {
                    UdpServer.totalVoiceDataRate = user.isSpeakingGlobally() ? (long)((double)UdpServer.totalVoiceDataRate - (double)(4000 * SoundCenter.userList.acceptedUsers.size()) * 0.8) : (UdpServer.totalVoiceDataRate -= (long)(4000 * user.listeners.size()));
                    user.setSpeaking(false);
                    user.setSpeakingGlobally(false);
                    SoundCenter.tcpServer.send((byte)41, null, null, user);
                    player.sendMessage(Messages.INFO_NOT_SPEAKING);
                }
                return true;
            }
        }
        sender.sendMessage(Messages.CMD_USAGE_SC);
        return true;
    }

    public void setMetadata(Player player, String key, Object value, Plugin plugin) {
        player.setMetadata(key, (MetadataValue)new FixedMetadataValue(plugin, value));
    }

    public Object getMetadata(Player player, String key, Plugin plugin) {
        List values = player.getMetadata(key);
        for (MetadataValue value : values) {
            if (!value.getOwningPlugin().getDescription().getName().equals(plugin.getDescription().getName())) continue;
            return value.value();
        }
        return null;
    }
}

