/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin;

import com.google.common.io.Files;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.soundcenter.soundcenter.lib.data.SCLocation;
import com.soundcenter.soundcenter.lib.data.SCLocation2D;
import com.soundcenter.soundcenter.lib.data.Station;
import com.soundcenter.soundcenter.lib.data.WGRegion;
import com.soundcenter.soundcenter.lib.util.FileOperation;
import com.soundcenter.soundcenter.plugin.Configuration;
import com.soundcenter.soundcenter.plugin.MainLoop;
import com.soundcenter.soundcenter.plugin.SCPlayerListener;
import com.soundcenter.soundcenter.plugin.commands.SCCommandExecutor;
import com.soundcenter.soundcenter.plugin.data.Database;
import com.soundcenter.soundcenter.plugin.data.UserList;
import com.soundcenter.soundcenter.plugin.network.tcp.TcpServer;
import com.soundcenter.soundcenter.plugin.network.udp.UdpServer;
import com.soundcenter.soundcenter.plugin.util.SCLogger;
import java.io.File;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SoundCenter
extends JavaPlugin {
    public static final double MIN_CL_VERSION = 0.3;
    public static final double MAX_CL_VERSION = 0.399;
    public static Configuration config = null;
    public static Database database = null;
    public static UserList userList = null;
    public static TcpServer tcpServer = null;
    public static UdpServer udpServer = null;
    public static SCLogger logger = null;
    public static File dataFile = new File("plugins" + File.separator + "SoundCenter" + File.separator + "data.scdb");
    private MainLoop mainLoop = new MainLoop();
    private static WorldGuardPlugin worldGuard = null;

    public void onEnable() {
        Thread.currentThread().setName("SoundCenter Plugin");
        config = new Configuration(this);
        logger = new SCLogger(this.getLogger(), config.debug());
        userList = new UserList();
        this.getCommand("sc").setExecutor((CommandExecutor)new SCCommandExecutor(this));
        this.getServer().getPluginManager().registerEvents((Listener)new SCPlayerListener(), (Plugin)this);
        if (dataFile.exists()) {
            try {
                database = (Database)FileOperation.loadObject(dataFile);
                if (SoundCenter.getWorldGuard() == null) {
                    logger.i("WorldGuard not loaded.", null);
                } else {
                    for (Map.Entry<Short, Station> entry : SoundCenter.database.wgRegions.entrySet()) {
                        WGRegion wgRegion = (WGRegion)entry.getValue();
                        World world = this.getServer().getWorld(wgRegion.getPoints().get(0).getWorld());
                        ProtectedRegion region = SoundCenter.getWorldGuard().getRegionManager(world).getRegion(wgRegion.getName());
                        if (region == null) {
                            database.removeStation(wgRegion);
                            continue;
                        }
                        SCLocation min = new SCLocation(region.getMinimumPoint().getX(), region.getMinimumPoint().getY(), region.getMinimumPoint().getZ(), world.getName(), "null");
                        SCLocation max = new SCLocation(region.getMaximumPoint().getX(), region.getMaximumPoint().getY(), region.getMaximumPoint().getZ(), world.getName(), "null");
                        wgRegion.setMin(min);
                        wgRegion.setMax(max);
                        ArrayList<SCLocation2D> points = new ArrayList<SCLocation2D>();
                        for (BlockVector2D point : region.getPoints()) {
                            points.add(new SCLocation2D(point.getX(), point.getZ(), world.getName()));
                        }
                        wgRegion.setPoints(points);
                    }
                }
                logger.i("Database loaded: " + SoundCenter.database.areas.size() + " areas, " + SoundCenter.database.boxes.size() + " boxes, " + database.getStationCount((byte)2) + " biome settings, " + database.getStationCount((byte)3) + " world settings and " + database.getStationCount((byte)4) + " WorldGuard regions.", null);
            }
            catch (InvalidClassException e) {
                database = new Database();
                logger.w("Found Database of incompatible SoundCenter Version. Old Database will be backed up to data.old.scdb", null);
                try {
                    Files.move((File)dataFile, (File)new File("plugins" + File.separator + "SoundCenter" + File.separator + "data.old.scdb"));
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e) {
                database = new Database();
                logger.w("Error while loading data.", e);
            }
        } else {
            database = new Database();
        }
        tcpServer = new TcpServer(config.port(), config.serverBindAddr());
        udpServer = new UdpServer(config.port(), config.serverBindAddr());
        new Thread(tcpServer).start();
        new Thread(udpServer).start();
        new Thread(this.mainLoop).start();
    }

    public void onDisable() {
        tcpServer.shutdown();
        udpServer.shutdown();
        this.mainLoop.shutdown();
        try {
            FileOperation.saveObject(dataFile, database);
            logger.i("Database saved: " + SoundCenter.database.areas.size() + " areas, " + SoundCenter.database.boxes.size() + " boxes, " + SoundCenter.database.biomes.size() + " biome settings and " + SoundCenter.database.worlds.size() + " world settings + " + SoundCenter.database.wgRegions.size() + " WorldGuard regions.", null);
        }
        catch (IOException e) {
            logger.w("Error while saving data.", e);
        }
        while (SoundCenter.tcpServer.active || SoundCenter.udpServer.active) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.i("SoundCenter disabled!", null);
    }

    public static WorldGuardPlugin getWorldGuard() {
        if (worldGuard == null) {
            Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("WorldGuard");
            if (plugin == null || !(plugin instanceof WorldGuardPlugin)) {
                return null;
            }
            worldGuard = (WorldGuardPlugin)plugin;
        }
        return worldGuard;
    }
}

