/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin;

import com.soundcenter.soundcenter.lib.udp.UdpPacket;
import com.soundcenter.soundcenter.plugin.SoundCenter;
import com.soundcenter.soundcenter.plugin.data.ServerUser;
import com.soundcenter.soundcenter.plugin.messages.Messages;
import com.soundcenter.soundcenter.plugin.util.IntersectionDetection;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class MainLoop
implements Runnable {
    private Thread thread = null;
    private boolean exit = false;

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        this.thread.setName("PositionsUpdater");
        while (!this.exit) {
            long timeB;
            int delay;
            long timeA = System.currentTimeMillis();
            if (!SoundCenter.userList.acceptedUsers.isEmpty()) {
                ServerUser[] userList = SoundCenter.userList.acceptedUsers.values().toArray(new ServerUser[0]);
                int i = 0;
                ServerUser[] serverUserArray = userList;
                int n = userList.length;
                int n2 = 0;
                while (n2 < n) {
                    ServerUser user = serverUserArray[n2];
                    Player player = user.getPlayer();
                    if (player != null && user.isInitialized()) {
                        Location loc = player.getLocation();
                        UdpPacket packet = new UdpPacket(82);
                        packet.setType((byte)20);
                        packet.setLocation(loc);
                        SoundCenter.udpServer.send(packet, user);
                        int k = i;
                        while (k < userList.length) {
                            ServerUser onlineUser = userList[k];
                            if (!onlineUser.equals(user) && (user.isSpeaking() || onlineUser.isSpeaking())) {
                                if (onlineUser.getPlayer() != null && onlineUser.isInitialized()) {
                                    short distance = IntersectionDetection.playerCanHear(onlineUser.getPlayer(), user.getPlayer(), SoundCenter.config.voiceRange());
                                    if (distance >= 0) {
                                        byte volumePercent = (byte)(100.0 - (double)distance / (double)SoundCenter.config.voiceRange() * 100.0);
                                        if (onlineUser.isVoiceActive()) {
                                            user.addListener(onlineUser, volumePercent);
                                        }
                                        if (user.isVoiceActive()) {
                                            onlineUser.addListener(user, volumePercent);
                                        }
                                    } else {
                                        user.removeListener(onlineUser);
                                        onlineUser.removeListener(user);
                                    }
                                }
                            } else {
                                user.removeListener(onlineUser);
                                onlineUser.removeListener(user);
                            }
                            ++k;
                        }
                        if (user.isSpeaking() && SoundCenter.config.voiceRemindTime() > 0 && timeA - user.getSpeakingStartTime() >= (long)(SoundCenter.config.voiceRemindTime() * 1000)) {
                            player.sendMessage(Messages.INFO_STILL_SPEAKING);
                            user.setSpeakingStartTime(timeA);
                        }
                    }
                    ++i;
                    ++n2;
                }
            }
            if ((delay = 33 - (int)((timeB = System.currentTimeMillis()) - timeA)) < 0) {
                delay = 0;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void shutdown() {
        this.exit = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }
}

