/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.plugin;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Configuration {
    private JavaPlugin plugin;
    private boolean debug;
    private boolean verifyIp;
    private boolean voiceEnabled;
    private String serverBindAddr;
    private String serverIp;
    private int port;
    private int serverCapacity;
    private int defaultBoxRange;
    private int defaultFadeout;
    private int maxBoxRange;
    private int maxAreaSize;
    private int maxBoxes;
    private int maxAreas;
    private int voiceRange;
    private int voiceRemindTime;
    private int maxBandwidth;

    public Configuration(JavaPlugin plugin) {
        this.plugin = plugin;
        this.load();
    }

    public void load() {
        this.plugin.reloadConfig();
        FileConfiguration cfg = this.plugin.getConfig();
        cfg.options().copyDefaults(true);
        cfg.addDefaults((Map)new HashMap<String, Object>(){
            {
                this.put("Debug-Mode", false);
                this.put("SC-Server-Bind-Address", "0.0.0.0");
                this.put("Server-IP", "");
                this.put("Port", 4224);
                this.put("Max-Users", 50);
                this.put("Verify-By-IP-Address", true);
                this.put("Enable-Voice-Chat", true);
                this.put("Default-Box-Range", 25);
                this.put("Default-Area-Fadeout", 10);
                this.put("Voice-Range", 30);
                this.put("Max-Box-Range", 50);
                this.put("Max-Area-Edge-Length", 150);
                this.put("Max-Boxes-Per-User", 5);
                this.put("Max-Areas-Per-User", 3);
                this.put("Remind-Of-Voice-Chat-Time", 60);
                this.put("Limit-Streaming-Bandwidth-Kb/s", 2048);
            }
        });
        this.debug = cfg.getBoolean("Debug-Mode");
        this.verifyIp = cfg.getBoolean("Verify-By-IP-Address");
        this.voiceEnabled = cfg.getBoolean("Enable-Voice-Chat");
        this.serverBindAddr = cfg.getString("SC-Server-Bind-Address");
        this.serverIp = cfg.getString("Server-IP");
        this.port = cfg.getInt("Port");
        this.serverCapacity = cfg.getInt("Max-Users");
        this.defaultBoxRange = cfg.getInt("Default-Box-Range");
        this.defaultFadeout = cfg.getInt("Default-Area-Fadeout");
        this.voiceRange = cfg.getInt("Voice-Range");
        this.maxBoxRange = cfg.getInt("Max-Box-Range");
        this.maxAreaSize = cfg.getInt("Max-Area-Edge-Length");
        this.maxBoxes = cfg.getInt("Max-Boxes-Per-User");
        this.maxAreas = cfg.getInt("Max-Areas-Per-User");
        this.voiceRemindTime = cfg.getInt("Remind-Of-Voice-Chat-Time");
        this.maxBandwidth = cfg.getInt("Limit-Streaming-Bandwidth-Kb/s");
        this.plugin.saveConfig();
    }

    public boolean debug() {
        return this.debug;
    }

    public boolean verifyIp() {
        return this.verifyIp;
    }

    public boolean voiceEnabled() {
        return this.voiceEnabled;
    }

    public String serverBindAddr() {
        return this.serverBindAddr;
    }

    public String serverIp() {
        return this.serverIp;
    }

    public int port() {
        return this.port;
    }

    public int serverCapacity() {
        return this.serverCapacity;
    }

    public int defaultBoxRange() {
        return this.defaultBoxRange;
    }

    public int defaultFadeout() {
        return this.defaultFadeout;
    }

    public int voiceRange() {
        return this.voiceRange;
    }

    public int maxBoxRange() {
        return this.maxBoxRange;
    }

    public int maxAreaSize() {
        return this.maxAreaSize;
    }

    public int maxBoxes() {
        return this.maxBoxes;
    }

    public int maxAreas() {
        return this.maxAreas;
    }

    public int voiceRemindTime() {
        return this.voiceRemindTime;
    }

    public int maxBandwidth() {
        return this.maxBandwidth;
    }
}

