/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.lib.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileOperation {
    public static void saveObject(File file, Object object) throws IOException {
        file.createNewFile();
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        out.writeObject(object);
        out.close();
    }

    public static Object loadObject(File file) throws InvalidClassException, Exception {
        if (!file.exists()) {
            return null;
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(file));
            Object object = in.readObject();
            in.close();
            return object;
        }
        catch (InvalidClassException e) {
            if (in != null) {
                in.close();
            }
            throw e;
        }
    }

    public static String getExtension(File file) {
        return FileOperation.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        String extension = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }

    public static List<File> listAllFiles(File directory) {
        File[] fList;
        ArrayList<File> resultList = new ArrayList<File>();
        File[] fileArray = fList = directory.listFiles();
        int n = fList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                resultList.add(file);
            } else if (file.isDirectory()) {
                resultList.addAll(FileOperation.listAllFiles(file));
            }
            ++n2;
        }
        return resultList;
    }

    public static boolean fileIsMidi(File file) {
        String name = file.getName();
        return FileOperation.getExtension(name).equalsIgnoreCase("mid") || FileOperation.getExtension(name).equalsIgnoreCase("midi");
    }

    public static long getDirectorySize(File directory) {
        long directorySize = 0L;
        File[] fileList = directory.listFiles();
        if (fileList == null) {
            return 0L;
        }
        int i = 0;
        while (i < fileList.length) {
            directorySize = fileList[i].isDirectory() ? (directorySize += FileOperation.getDirectorySize(fileList[i])) : (directorySize += fileList[i].length());
            ++i;
        }
        return directorySize;
    }
}

