/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.lib.udp;

import com.soundcenter.soundcenter.lib.data.SCLocation;
import com.soundcenter.soundcenter.lib.util.StringUtil;
import java.nio.ByteBuffer;
import org.bukkit.Location;

public class UdpPacket {
    public static final int HEADER_SIZE = 10;
    private byte[] data;

    public UdpPacket(int length) {
        this.data = new byte[length];
    }

    public UdpPacket(byte[] data) {
        this.data = data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.data.length;
    }

    public void setIdent(short ident) {
        this.putShort(0, ident);
    }

    public short getIdent() {
        return this.readShort(0);
    }

    public void setSeq(short seq) {
        this.putShort(2, seq);
    }

    public short getSeq() {
        return this.readShort(2);
    }

    public void setDestUserID(short id) {
        this.putShort(4, id);
    }

    public short getDestUserID() {
        return this.readShort(4);
    }

    public void setID(short id) {
        this.putShort(6, id);
    }

    public short getID() {
        return this.readShort(6);
    }

    public void setType(byte type) {
        this.data[8] = type;
    }

    public byte getType() {
        return this.data[8];
    }

    public void setVolume(byte value) {
        this.data[9] = value;
    }

    public byte getVolume() {
        return this.data[9];
    }

    public void setStreamData(byte[] sData) {
        this.putBytes(10, sData);
    }

    public byte[] getStreamData() {
        return this.readBytes(10, this.data.length - 10);
    }

    public void setLocation(Location loc) {
        this.putDouble(10, loc.getX());
        this.putDouble(18, loc.getY());
        this.putDouble(26, loc.getZ());
        String worldName = StringUtil.cutForUdp(loc.getWorld().getName());
        this.putString(34, worldName);
        String biomeName = StringUtil.cutForUdp(loc.getWorld().getBiome(loc.getBlockX(), loc.getBlockZ()).toString());
        this.putString(58, biomeName);
    }

    public SCLocation getLocation() {
        double x = this.readDouble(10);
        double y = this.readDouble(18);
        double z = this.readDouble(26);
        String world = this.readString(34);
        String biome = this.readString(58);
        return new SCLocation(x, y, z, world, biome);
    }

    public void putShort(int at, short value) {
        ByteBuffer.wrap(this.data).putShort(at, value);
    }

    public short readShort(int at) {
        return ByteBuffer.wrap(this.data).getShort(at);
    }

    public void putDouble(int at, double value) {
        ByteBuffer.wrap(this.data).putDouble(at, value);
    }

    public double readDouble(int at) {
        return ByteBuffer.wrap(this.data).getDouble(at);
    }

    public void putString(int at, String value) {
        byte length;
        byte[] stringBytes = value.getBytes();
        this.data[at] = length = (byte)stringBytes.length;
        this.putBytes(at + 1, stringBytes);
    }

    public String readString(int at) {
        int length = this.data[at];
        if (length > 23) {
            length = 23;
        }
        byte[] stringBytes = this.readBytes(at + 1, length);
        return new String(stringBytes);
    }

    public void putBytes(int at, byte[] value) {
        System.arraycopy(value, 0, this.data, at, value.length);
    }

    public byte[] readBytes(int at, int length) {
        byte[] result = new byte[length];
        System.arraycopy(this.data, at, result, 0, length);
        return result;
    }
}

