/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.lib.data;

import com.soundcenter.soundcenter.lib.util.StringUtil;
import java.io.Serializable;
import org.bukkit.Location;

public class SCLocation2D
implements Serializable {
    private static final long serialVersionUID = 4L;
    private double x;
    private double z;
    private String world;

    public SCLocation2D(double x, double z, String world) {
        this.x = x;
        this.z = z;
        this.world = StringUtil.cutForUdp(world);
    }

    public SCLocation2D(Location loc) {
        this.x = loc.getX();
        this.z = loc.getZ();
        this.world = StringUtil.cutForUdp(loc.getWorld().getName());
    }

    public double distance(SCLocation2D o) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot measure distance to a null location");
        }
        if (o.getWorld() == null || this.getWorld() == null) {
            throw new IllegalArgumentException("Cannot measure distance to a null world");
        }
        if (!o.getWorld().equals(this.getWorld())) {
            throw new IllegalArgumentException("Cannot measure distance between " + this.getWorld() + " and " + o.getWorld());
        }
        return Math.sqrt(Math.pow(this.x - o.x, 2.0) + Math.pow(this.z - o.z, 2.0));
    }

    public String getPoint() {
        return "(" + this.getBlockX() + ", " + ", " + this.getBlockZ() + ")";
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return (int)this.x;
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return (int)this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setZ(double x) {
        this.x = x;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = StringUtil.cutForUdp(world);
    }

    public boolean sameAs(SCLocation2D other) {
        return other.x == this.x && other.z == this.z && other.world.equals(this.world);
    }

    public String toString() {
        return "X: " + this.x + " Z: " + this.z + " world: " + this.world;
    }
}

