/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.lib.data;

import com.soundcenter.soundcenter.lib.util.StringUtil;
import java.io.Serializable;
import org.bukkit.Location;

public class SCLocation
implements Serializable {
    private static final long serialVersionUID = 4L;
    private double x;
    private double y;
    private double z;
    private String world;
    private String biome;

    public SCLocation(double x, double y, double z, String world, String biome) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = StringUtil.cutForUdp(world);
        this.biome = StringUtil.cutForUdp(biome);
    }

    public SCLocation(Location loc) {
        this.x = loc.getX();
        this.y = loc.getY();
        this.z = loc.getZ();
        this.world = StringUtil.cutForUdp(loc.getWorld().getName());
        this.biome = StringUtil.cutForUdp(loc.getWorld().getBiome(loc.getBlockX(), loc.getBlockZ()).toString());
    }

    public double distance(SCLocation o) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot measure distance to a null location");
        }
        if (o.getWorld() == null || this.getWorld() == null) {
            throw new IllegalArgumentException("Cannot measure distance to a null world");
        }
        if (!o.getWorld().equals(this.getWorld())) {
            throw new IllegalArgumentException("Cannot measure distance between " + this.getWorld() + " and " + o.getWorld());
        }
        return Math.sqrt(Math.pow(this.x - o.x, 2.0) + Math.pow(this.y - o.y, 2.0) + Math.pow(this.z - o.z, 2.0));
    }

    public String getPoint() {
        return "(" + this.getBlockX() + ", " + this.getBlockY() + ", " + this.getBlockZ() + ")";
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return (int)this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getBlockY() {
        return (int)this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return (int)this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double x) {
        this.x = x;
    }

    public void setZ(double x) {
        this.x = x;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = StringUtil.cutForUdp(world);
    }

    public String getBiome() {
        return this.biome;
    }

    public void setBiome(String biome) {
        this.biome = StringUtil.cutForUdp(biome);
    }

    public static SCLocation getMinimum(SCLocation v1, SCLocation v2) {
        if (!v1.world.equals(v2.world)) {
            return null;
        }
        return new SCLocation(Math.min(v1.x, v2.x), Math.min(v1.y, v2.y), Math.min(v1.z, v2.z), v1.world, v1.biome);
    }

    public static SCLocation getMaximum(SCLocation v1, SCLocation v2) {
        if (!v1.world.equals(v2.world)) {
            return null;
        }
        return new SCLocation(Math.max(v1.x, v2.x), Math.max(v1.y, v2.y), Math.max(v1.z, v2.z), v1.world, v1.biome);
    }

    public boolean sameAs(SCLocation other) {
        return other.x == this.x && other.y == this.y && other.z == this.z && other.world.equals(this.world) && other.biome.equals(this.biome);
    }

    public String toString() {
        return "X: " + this.x + " Y: " + this.y + " Z: " + this.z + " world: " + this.world + " biome: " + this.biome;
    }
}

