/*
 * Decompiled with CFR 0.152.
 */
package com.soundcenter.soundcenter.lib.data;

import com.soundcenter.soundcenter.lib.data.SCLocation;
import com.soundcenter.soundcenter.lib.data.SCLocation2D;
import com.soundcenter.soundcenter.lib.data.Song;
import com.soundcenter.soundcenter.lib.data.Station;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Area
implements Station,
Serializable {
    private static final long serialVersionUID = 4L;
    private byte type = 0;
    private short id = 0;
    private SCLocation min = null;
    private SCLocation max = null;
    private String owner = null;
    private byte priority = 1;
    private byte maxVolume = (byte)100;
    private boolean editableByOthers = false;
    private boolean startFromBeginning = false;
    private boolean loop = true;
    private int fadeout = 10;
    private List<Song> songs = new ArrayList<Song>();

    public Area(short id, String owner, SCLocation c1, SCLocation c2, int fadeout) {
        this.id = id;
        this.owner = owner;
        this.setCorners(c1, c2);
        this.fadeout = fadeout;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public short getId() {
        return this.id;
    }

    @Override
    public void setId(short id) {
        this.id = id;
    }

    @Override
    public SCLocation getMin() {
        return this.min;
    }

    @Override
    public SCLocation getMax() {
        return this.max;
    }

    public void setCorners(SCLocation c1, SCLocation c2) {
        this.min = SCLocation.getMinimum(c1, c2);
        this.max = SCLocation.getMaximum(c1, c2);
    }

    @Override
    public String getWorld() {
        return this.min.getWorld();
    }

    public void setWorld(String world) {
        this.min.setWorld(world);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        this.priority = priority;
    }

    @Override
    public byte getMaxVolume() {
        return this.maxVolume;
    }

    @Override
    public void setMaxVolume(byte maxVolume) {
        this.maxVolume = maxVolume;
    }

    @Override
    public boolean isEditableByOthers() {
        return this.editableByOthers;
    }

    @Override
    public void setEditableByOthers(boolean editableByOthers) {
        this.editableByOthers = editableByOthers;
    }

    @Override
    public int getRange() {
        return this.fadeout;
    }

    @Override
    public void setRange(int fadeout) {
        this.fadeout = fadeout;
    }

    @Override
    public void addSong(Song song) {
        this.songs.add(song);
    }

    @Override
    public void removeSong(Song song) {
        this.songs.remove(song);
    }

    @Override
    public void removeAllSongs() {
        this.songs.clear();
    }

    @Override
    public List<Song> getSongs() {
        return this.songs;
    }

    @Override
    public boolean shouldStartFromBeginning() {
        return this.startFromBeginning;
    }

    @Override
    public void setStartFromBeginning(boolean value) {
        this.startFromBeginning = value;
    }

    @Override
    public boolean shouldLoop() {
        return this.loop;
    }

    @Override
    public void setLoop(boolean value) {
        this.loop = value;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public SCLocation getLocation() {
        return null;
    }

    @Override
    public List<SCLocation2D> getPoints() {
        return null;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.maxVolume == 0) {
            this.maxVolume = (byte)100;
        }
    }
}

