/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission;

import java.util.logging.Logger;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public abstract class Permission {
    protected static final Logger log = Logger.getLogger("Minecraft");
    protected Plugin plugin = null;

    public abstract String getName();

    public abstract boolean isEnabled();

    public abstract boolean hasSuperPermsCompat();

    @Deprecated
    public boolean has(String world, String player, String permission) {
        if (world == null) {
            return this.playerHas((String)null, player, permission);
        }
        return this.playerHas(world, player, permission);
    }

    @Deprecated
    public boolean has(World world, String player, String permission) {
        if (world == null) {
            return this.playerHas((String)null, player, permission);
        }
        return this.playerHas(world.getName(), player, permission);
    }

    public boolean has(CommandSender sender, String permission) {
        return sender.hasPermission(permission);
    }

    public boolean has(Player player, String permission) {
        return player.hasPermission(permission);
    }

    @Deprecated
    public abstract boolean playerHas(String var1, String var2, String var3);

    @Deprecated
    public boolean playerHas(World world, String player, String permission) {
        if (world == null) {
            return this.playerHas((String)null, player, permission);
        }
        return this.playerHas(world.getName(), player, permission);
    }

    public boolean playerHas(String world, OfflinePlayer player, String permission) {
        if (world == null) {
            return this.has((String)null, player.getName(), permission);
        }
        return this.has(world, player.getName(), permission);
    }

    public boolean playerHas(Player player, String permission) {
        return this.has(player, permission);
    }

    @Deprecated
    public abstract boolean playerAdd(String var1, String var2, String var3);

    @Deprecated
    public boolean playerAdd(World world, String player, String permission) {
        if (world == null) {
            return this.playerAdd((String)null, player, permission);
        }
        return this.playerAdd(world.getName(), player, permission);
    }

    public boolean playerAdd(String world, OfflinePlayer player, String permission) {
        if (world == null) {
            return this.playerAdd((String)null, player.getName(), permission);
        }
        return this.playerAdd(world, player.getName(), permission);
    }

    public boolean playerAdd(Player player, String permission) {
        return this.playerAdd(player.getWorld().getName(), (OfflinePlayer)player, permission);
    }

    @Deprecated
    public boolean playerAddTransient(String player, String permission) throws UnsupportedOperationException {
        Player p = this.plugin.getServer().getPlayer(player);
        if (p == null) {
            throw new UnsupportedOperationException(this.getName() + " does not support offline player transient permissions!");
        }
        return this.playerAddTransient(p, permission);
    }

    public boolean playerAddTransient(OfflinePlayer player, String permission) throws UnsupportedOperationException {
        if (player.isOnline()) {
            return this.playerAddTransient((Player)player, permission);
        }
        throw new UnsupportedOperationException(this.getName() + " does not support offline player transient permissions!");
    }

    public boolean playerAddTransient(Player player, String permission) {
        for (PermissionAttachmentInfo paInfo : player.getEffectivePermissions()) {
            if (paInfo.getAttachment() == null || !paInfo.getAttachment().getPlugin().equals(this.plugin)) continue;
            paInfo.getAttachment().setPermission(permission, true);
            return true;
        }
        PermissionAttachment attach = player.addAttachment(this.plugin);
        attach.setPermission(permission, true);
        return true;
    }

    public boolean playerAddTransient(String worldName, OfflinePlayer player, String permission) {
        return this.playerAddTransient(worldName, player.getName(), permission);
    }

    public boolean playerAddTransient(String worldName, Player player, String permission) {
        return this.playerAddTransient(player, permission);
    }

    @Deprecated
    public boolean playerAddTransient(String worldName, String player, String permission) {
        Player p = this.plugin.getServer().getPlayer(player);
        if (p == null) {
            throw new UnsupportedOperationException(this.getName() + " does not support offline player transient permissions!");
        }
        return this.playerAddTransient(p, permission);
    }

    @Deprecated
    public boolean playerRemoveTransient(String worldName, String player, String permission) {
        Player p = this.plugin.getServer().getPlayer(player);
        if (p == null) {
            return false;
        }
        return this.playerRemoveTransient(p, permission);
    }

    public boolean playerRemoveTransient(String worldName, OfflinePlayer player, String permission) {
        return this.playerRemoveTransient(worldName, player.getName(), permission);
    }

    public boolean playerRemoveTransient(String worldName, Player player, String permission) {
        return this.playerRemoveTransient(worldName, (OfflinePlayer)player, permission);
    }

    @Deprecated
    public abstract boolean playerRemove(String var1, String var2, String var3);

    public boolean playerRemove(String world, OfflinePlayer player, String permission) {
        if (world == null) {
            return this.playerRemove((String)null, player.getName(), permission);
        }
        return this.playerRemove(world, player.getName(), permission);
    }

    @Deprecated
    public boolean playerRemove(World world, String player, String permission) {
        if (world == null) {
            return this.playerRemove((String)null, player, permission);
        }
        return this.playerRemove(world.getName(), player, permission);
    }

    public boolean playerRemove(Player player, String permission) {
        return this.playerRemove(player.getWorld().getName(), (OfflinePlayer)player, permission);
    }

    @Deprecated
    public boolean playerRemoveTransient(String player, String permission) {
        Player p = this.plugin.getServer().getPlayer(player);
        if (p == null) {
            return false;
        }
        return this.playerRemoveTransient(p, permission);
    }

    public boolean playerRemoveTransient(OfflinePlayer player, String permission) {
        if (player.isOnline()) {
            return this.playerRemoveTransient((Player)player, permission);
        }
        return false;
    }

    public boolean playerRemoveTransient(Player player, String permission) {
        for (PermissionAttachmentInfo paInfo : player.getEffectivePermissions()) {
            if (paInfo.getAttachment() == null || !paInfo.getAttachment().getPlugin().equals(this.plugin)) continue;
            paInfo.getAttachment().unsetPermission(permission);
            return true;
        }
        return false;
    }

    public abstract boolean groupHas(String var1, String var2, String var3);

    public boolean groupHas(World world, String group, String permission) {
        if (world == null) {
            return this.groupHas((String)null, group, permission);
        }
        return this.groupHas(world.getName(), group, permission);
    }

    public abstract boolean groupAdd(String var1, String var2, String var3);

    public boolean groupAdd(World world, String group, String permission) {
        if (world == null) {
            return this.groupAdd((String)null, group, permission);
        }
        return this.groupAdd(world.getName(), group, permission);
    }

    public abstract boolean groupRemove(String var1, String var2, String var3);

    public boolean groupRemove(World world, String group, String permission) {
        if (world == null) {
            return this.groupRemove((String)null, group, permission);
        }
        return this.groupRemove(world.getName(), group, permission);
    }

    @Deprecated
    public abstract boolean playerInGroup(String var1, String var2, String var3);

    @Deprecated
    public boolean playerInGroup(World world, String player, String group) {
        if (world == null) {
            return this.playerInGroup((String)null, player, group);
        }
        return this.playerInGroup(world.getName(), player, group);
    }

    public boolean playerInGroup(String world, OfflinePlayer player, String group) {
        if (world == null) {
            return this.playerInGroup((String)null, player.getName(), group);
        }
        return this.playerInGroup(world, player.getName(), group);
    }

    public boolean playerInGroup(Player player, String group) {
        return this.playerInGroup(player.getWorld().getName(), (OfflinePlayer)player, group);
    }

    @Deprecated
    public abstract boolean playerAddGroup(String var1, String var2, String var3);

    @Deprecated
    public boolean playerAddGroup(World world, String player, String group) {
        if (world == null) {
            return this.playerAddGroup((String)null, player, group);
        }
        return this.playerAddGroup(world.getName(), player, group);
    }

    public boolean playerAddGroup(String world, OfflinePlayer player, String group) {
        if (world == null) {
            return this.playerAddGroup((String)null, player.getName(), group);
        }
        return this.playerAddGroup(world, player.getName(), group);
    }

    public boolean playerAddGroup(Player player, String group) {
        return this.playerAddGroup(player.getWorld().getName(), (OfflinePlayer)player, group);
    }

    @Deprecated
    public abstract boolean playerRemoveGroup(String var1, String var2, String var3);

    @Deprecated
    public boolean playerRemoveGroup(World world, String player, String group) {
        if (world == null) {
            return this.playerRemoveGroup((String)null, player, group);
        }
        return this.playerRemoveGroup(world.getName(), player, group);
    }

    public boolean playerRemoveGroup(String world, OfflinePlayer player, String group) {
        if (world == null) {
            return this.playerRemoveGroup((String)null, player.getName(), group);
        }
        return this.playerRemoveGroup(world, player.getName(), group);
    }

    public boolean playerRemoveGroup(Player player, String group) {
        return this.playerRemoveGroup(player.getWorld().getName(), (OfflinePlayer)player, group);
    }

    @Deprecated
    public abstract String[] getPlayerGroups(String var1, String var2);

    @Deprecated
    public String[] getPlayerGroups(World world, String player) {
        if (world == null) {
            return this.getPlayerGroups((String)null, player);
        }
        return this.getPlayerGroups(world.getName(), player);
    }

    public String[] getPlayerGroups(String world, OfflinePlayer player) {
        return this.getPlayerGroups(world, player.getName());
    }

    public String[] getPlayerGroups(Player player) {
        return this.getPlayerGroups(player.getWorld().getName(), (OfflinePlayer)player);
    }

    @Deprecated
    public abstract String getPrimaryGroup(String var1, String var2);

    @Deprecated
    public String getPrimaryGroup(World world, String player) {
        if (world == null) {
            return this.getPrimaryGroup((String)null, player);
        }
        return this.getPrimaryGroup(world.getName(), player);
    }

    public String getPrimaryGroup(String world, OfflinePlayer player) {
        return this.getPrimaryGroup(world, player.getName());
    }

    public String getPrimaryGroup(Player player) {
        return this.getPrimaryGroup(player.getWorld().getName(), (OfflinePlayer)player);
    }

    public abstract String[] getGroups();

    public abstract boolean hasGroupSupport();
}

