/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.util;

public class StringUtils {
    public static String stripChars(String input, String removed) {
        if (removed == null || removed.isEmpty()) {
            return input;
        }
        return StringUtils.stripChars(input, removed.toCharArray());
    }

    public static String getCleanCommand(String message) {
        char[] chars = message.toCharArray();
        if (chars.length <= 1) {
            return "";
        }
        int pos = 0;
        int i = 1;
        while (i < chars.length) {
            if (chars[i] == ' ') break;
            chars[pos++] = chars[i];
            ++i;
        }
        return new String(chars, 0, pos);
    }

    public static String stripChars(String input, char ... removed) {
        if (input == null || input.isEmpty() || removed.length == 0) {
            return input;
        }
        char[] chars = input.toCharArray();
        int pos = 0;
        int i = 0;
        while (i < chars.length) {
            if (!StringUtils.arrayContains(removed, chars[i])) {
                chars[pos++] = chars[i];
            }
            ++i;
        }
        return new String(chars, 0, pos);
    }

    private static boolean arrayContains(char[] arr, char match) {
        char[] cArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == match) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String capitalizeFully(String input) {
        if (input == null) {
            return null;
        }
        String s = input.toLowerCase();
        int strLen = s.length();
        StringBuffer buffer = new StringBuffer(strLen);
        boolean capitalizeNext = true;
        int i = 0;
        while (i < strLen) {
            char ch = s.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                capitalizeNext = true;
            } else if (capitalizeNext) {
                buffer.append(Character.toTitleCase(ch));
                capitalizeNext = false;
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

