/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.util;

import com.gmail.filoghost.chestcommands.exception.FormatException;
import com.gmail.filoghost.chestcommands.util.StringUtils;
import com.gmail.filoghost.chestcommands.util.Utils;
import com.gmail.filoghost.chestcommands.util.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemStackReader {
    private Material material = Material.STONE;
    private int amount = 1;
    private short dataValue = 0;
    private boolean explicitDataValue = false;

    public ItemStackReader(String input, boolean parseAmount) throws FormatException {
        Material material;
        String[] splitByColons;
        String[] splitAmount;
        Validate.notNull(input, "input cannot be null");
        input = StringUtils.stripChars(input, " _-");
        if (parseAmount && (splitAmount = input.split(",")).length > 1) {
            if (!Utils.isValidInteger(splitAmount[1])) {
                throw new FormatException("invalid amount \"" + splitAmount[1] + "\"");
            }
            int amount = Integer.parseInt(splitAmount[1]);
            if (amount <= 0) {
                throw new FormatException("invalid amount \"" + splitAmount[1] + "\"");
            }
            this.amount = amount;
            input = splitAmount[0];
        }
        if ((splitByColons = input.split(":")).length > 1) {
            if (!Utils.isValidShort(splitByColons[1])) {
                throw new FormatException("invalid data value \"" + splitByColons[1] + "\"");
            }
            short dataValue = Short.parseShort(splitByColons[1]);
            if (dataValue < 0) {
                throw new FormatException("invalid data value \"" + splitByColons[1] + "\"");
            }
            this.explicitDataValue = true;
            this.dataValue = dataValue;
            input = splitByColons[0];
        }
        if ((material = Utils.matchMaterial(input)) == null || material == Material.AIR) {
            throw new FormatException("invalid material \"" + input + "\"");
        }
        this.material = material;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    public short getDataValue() {
        return this.dataValue;
    }

    public boolean hasExplicitDataValue() {
        return this.explicitDataValue;
    }

    public ItemStack createStack() {
        return new ItemStack(this.material, this.amount, this.dataValue);
    }
}

