/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.serializer;

import com.gmail.filoghost.chestcommands.api.Icon;
import com.gmail.filoghost.chestcommands.config.yaml.PluginConfig;
import com.gmail.filoghost.chestcommands.exception.FormatException;
import com.gmail.filoghost.chestcommands.internal.ExtendedIconMenu;
import com.gmail.filoghost.chestcommands.internal.MenuData;
import com.gmail.filoghost.chestcommands.serializer.CommandSerializer;
import com.gmail.filoghost.chestcommands.serializer.IconSerializer;
import com.gmail.filoghost.chestcommands.util.ClickType;
import com.gmail.filoghost.chestcommands.util.ErrorLogger;
import com.gmail.filoghost.chestcommands.util.ItemStackReader;
import com.gmail.filoghost.chestcommands.util.Utils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class MenuSerializer {
    public static ExtendedIconMenu loadMenu(PluginConfig config, String title, int rows, ErrorLogger errorLogger) {
        ExtendedIconMenu iconMenu = new ExtendedIconMenu(title, rows, config.getFileName());
        for (String subSectionName : config.getKeys(false)) {
            if (subSectionName.equals("menu-settings")) continue;
            ConfigurationSection iconSection = config.getConfigurationSection(subSectionName);
            Icon icon = IconSerializer.loadIconFromSection(iconSection, subSectionName, config.getFileName(), errorLogger);
            IconSerializer.Coords coords = IconSerializer.loadCoordsFromSection(iconSection);
            if (!coords.isSetX() || !coords.isSetY()) {
                errorLogger.addError("The icon \"" + subSectionName + "\" in the menu \"" + config.getFileName() + " is missing POSITION-X and/or POSITION-Y.");
                continue;
            }
            if (iconMenu.getIcon(coords.getX(), coords.getY()) != null) {
                errorLogger.addError("The icon \"" + subSectionName + "\" in the menu \"" + config.getFileName() + " is overriding another icon with the same position.");
            }
            iconMenu.setIcon(coords.getX(), coords.getY(), icon);
        }
        return iconMenu;
    }

    public static MenuData loadMenuData(PluginConfig config, ErrorLogger errorLogger) {
        int rows;
        String title = Utils.addColors(config.getString("menu-settings.name"));
        if (title == null) {
            errorLogger.addError("The menu \"" + config.getFileName() + "\" doesn't have a name set.");
            title = ChatColor.DARK_RED + "No title set";
        }
        if (title.length() > 32) {
            title = title.substring(0, 32);
        }
        if (config.isInt("menu-settings.rows")) {
            rows = config.getInt("menu-settings.rows");
            if (rows <= 0) {
                rows = 1;
            }
        } else {
            rows = 6;
            errorLogger.addError("The menu \"" + config.getFileName() + "\" doesn't have a the number of rows set, it will have 6 rows by default.");
        }
        MenuData menuData = new MenuData(title, rows);
        if (config.isSet("menu-settings.command")) {
            menuData.setCommands(config.getString("menu-settings.command").replace(" ", "").split(";"));
        }
        if (config.isSet("menu-settings.open-action")) {
            menuData.setOpenActions(CommandSerializer.readCommands(config.getString("menu-settings.open-action")));
        }
        if (config.isSet("menu-settings.open-with-item.id")) {
            try {
                ItemStackReader itemReader = new ItemStackReader(config.getString("menu-settings.open-with-item.id"), false);
                menuData.setBoundMaterial(itemReader.getMaterial());
                if (itemReader.hasExplicitDataValue()) {
                    menuData.setBoundDataValue(itemReader.getDataValue());
                }
            }
            catch (FormatException e) {
                errorLogger.addError("The item \"" + config.getString("menu-settings.open-with-item.id") + "\" used to open the menu \"" + config.getFileName() + "\" is invalid: " + e.getMessage());
            }
            boolean leftClick = config.getBoolean("menu-settings.open-with-item.left-click");
            boolean rightClick = config.getBoolean("menu-settings.open-with-item.right-click");
            if (leftClick || rightClick) {
                menuData.setClickType(ClickType.fromOptions(leftClick, rightClick));
            }
        }
        if (config.isSet("menu-settings.auto-refresh")) {
            double autoRefresh = config.getDouble("menu-settings.auto-refresh");
            int tenthsToRefresh = autoRefresh <= 0.1 ? 1 : (int)(autoRefresh * 10.0);
            menuData.setRefreshTenths(tenthsToRefresh);
        }
        return menuData;
    }

    private static class Nodes {
        public static final String MENU_NAME = "menu-settings.name";
        public static final String MENU_ROWS = "menu-settings.rows";
        public static final String MENU_COMMAND = "menu-settings.command";
        public static final String OPEN_ACTION = "menu-settings.open-action";
        public static final String OPEN_ITEM_MATERIAL = "menu-settings.open-with-item.id";
        public static final String OPEN_ITEM_LEFT_CLICK = "menu-settings.open-with-item.left-click";
        public static final String OPEN_ITEM_RIGHT_CLICK = "menu-settings.open-with-item.right-click";
        public static final String AUTO_REFRESH = "menu-settings.auto-refresh";

        private Nodes() {
        }
    }
}

