/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.serializer;

import com.gmail.filoghost.chestcommands.api.Icon;
import com.gmail.filoghost.chestcommands.config.AsciiPlaceholders;
import com.gmail.filoghost.chestcommands.exception.FormatException;
import com.gmail.filoghost.chestcommands.internal.CommandsClickHandler;
import com.gmail.filoghost.chestcommands.internal.RequiredItem;
import com.gmail.filoghost.chestcommands.internal.icon.ExtendedIcon;
import com.gmail.filoghost.chestcommands.internal.icon.IconCommand;
import com.gmail.filoghost.chestcommands.serializer.CommandSerializer;
import com.gmail.filoghost.chestcommands.serializer.EnchantmentSerializer;
import com.gmail.filoghost.chestcommands.util.ErrorLogger;
import com.gmail.filoghost.chestcommands.util.ItemStackReader;
import com.gmail.filoghost.chestcommands.util.Utils;
import com.gmail.filoghost.chestcommands.util.Validate;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class IconSerializer {
    public static Icon loadIconFromSection(ConfigurationSection section, String iconName, String menuFileName, ErrorLogger errorLogger) {
        double price;
        Validate.notNull(section, "ConfigurationSection cannot be null");
        ExtendedIcon icon = new ExtendedIcon();
        if (section.isSet("ID")) {
            try {
                ItemStackReader itemReader = new ItemStackReader(section.getString("ID"), true);
                icon.setMaterial(itemReader.getMaterial());
                icon.setDataValue(itemReader.getDataValue());
                icon.setAmount(itemReader.getAmount());
            }
            catch (FormatException e) {
                errorLogger.addError("The icon \"" + iconName + "\" in the menu \"" + menuFileName + "\" has an invalid ID: " + e.getMessage());
            }
        }
        if (section.isSet("DATA-VALUE")) {
            icon.setDataValue((short)section.getInt("DATA-VALUE"));
        }
        if (section.isSet("AMOUNT")) {
            icon.setAmount(section.getInt("AMOUNT"));
        }
        icon.setName(AsciiPlaceholders.placeholdersToSymbols(Utils.colorizeName(section.getString("NAME"))));
        icon.setLore(AsciiPlaceholders.placeholdersToSymbols(Utils.colorizeLore(section.getStringList("LORE"))));
        if (section.isSet("ENCHANTMENT")) {
            icon.setEnchantments(EnchantmentSerializer.loadEnchantments(section.getString("ENCHANTMENT"), iconName, menuFileName, errorLogger));
        }
        if (section.isSet("COLOR")) {
            try {
                icon.setColor(Utils.parseColor(section.getString("COLOR")));
            }
            catch (FormatException e) {
                errorLogger.addError("The icon \"" + iconName + "\" in the menu \"" + menuFileName + "\" has an invalid COLOR: " + e.getMessage());
            }
        }
        icon.setSkullOwner(section.getString("SKULL-OWNER"));
        icon.setPermission(section.getString("PERMISSION"));
        icon.setPermissionMessage(Utils.addColors(section.getString("PERMISSION-MESSAGE")));
        icon.setViewPermission(section.getString("VIEW-PERMISSION"));
        boolean closeOnClick = !section.getBoolean("KEEP-OPEN");
        icon.setCloseOnClick(closeOnClick);
        if (section.isSet("COMMAND")) {
            List<IconCommand> commands;
            if (section.isList("COMMAND")) {
                commands = Utils.newArrayList();
                for (String commandString : section.getStringList("COMMAND")) {
                    if (commandString.isEmpty()) continue;
                    commands.add(CommandSerializer.matchCommand(commandString));
                }
            } else {
                commands = CommandSerializer.readCommands(section.getString("COMMAND"));
            }
            icon.setClickHandler(new CommandsClickHandler(commands, closeOnClick));
        }
        if ((price = section.getDouble("PRICE")) > 0.0) {
            icon.setMoneyPrice(price);
        } else if (price < 0.0) {
            errorLogger.addError("The icon \"" + iconName + "\" in the menu \"" + menuFileName + "\" has a negative PRICE: " + price);
        }
        int points = section.getInt("POINTS");
        if (points > 0) {
            icon.setPlayerPointsPrice(points);
        } else if (points < 0) {
            errorLogger.addError("The icon \"" + iconName + "\" in the menu \"" + menuFileName + "\" has negative POINTS: " + points);
        }
        int levels = section.getInt("LEVELS");
        if (levels > 0) {
            icon.setExpLevelsPrice(levels);
        } else if (levels < 0) {
            errorLogger.addError("The icon \"" + iconName + "\" in the menu \"" + menuFileName + "\" has negative LEVELS: " + levels);
        }
        if (section.isSet("REQUIRED-ITEM")) {
            try {
                ItemStackReader itemReader = new ItemStackReader(section.getString("REQUIRED-ITEM"), true);
                RequiredItem requiredItem = new RequiredItem(itemReader.getMaterial(), itemReader.getAmount());
                if (itemReader.hasExplicitDataValue()) {
                    requiredItem.setRestrictiveDataValue(itemReader.getDataValue());
                }
                icon.setRequiredItem(requiredItem);
            }
            catch (FormatException e) {
                errorLogger.addError("The icon \"" + iconName + "\" in the menu \"" + menuFileName + "\" has an invalid REQUIRED-ITEM: " + e.getMessage());
            }
        }
        return icon;
    }

    public static Coords loadCoordsFromSection(ConfigurationSection section) {
        Validate.notNull(section, "ConfigurationSection cannot be null");
        Integer x = null;
        Integer y = null;
        if (section.isInt("POSITION-X")) {
            x = section.getInt("POSITION-X");
        }
        if (section.isInt("POSITION-Y")) {
            y = section.getInt("POSITION-Y");
        }
        return new Coords(x, y);
    }

    public static void saveToSection(Icon icon, ConfigurationSection section) {
        Validate.notNull(icon, "Icon cannot be null");
        Validate.notNull(section, "ConfigurationSection cannot be null");
        section.set("ID", (Object)IconSerializer.serializeIconID(icon));
        if (icon.getEnchantments().size() > 0) {
            section.set("ENCHANTMENT", (Object)1);
        }
    }

    public static String serializeIconID(Icon icon) {
        if (icon.getMaterial() == null) {
            return "Not set";
        }
        StringBuilder output = new StringBuilder();
        output.append(Utils.formatMaterial(icon.getMaterial()));
        if (icon.getDataValue() > 0) {
            output.append(":");
            output.append(icon.getDataValue());
        }
        if (icon.getAmount() != 1) {
            output.append(", ");
            output.append(icon.getAmount());
        }
        return output.toString();
    }

    public static class Coords {
        private Integer x;
        private Integer y;

        protected Coords(Integer x, Integer y) {
            this.x = x;
            this.y = y;
        }

        public boolean isSetX() {
            return this.x != null;
        }

        public boolean isSetY() {
            return this.y != null;
        }

        public Integer getX() {
            return this.x;
        }

        public Integer getY() {
            return this.y;
        }
    }

    private static class Nodes {
        public static final String ID = "ID";
        public static final String DATA_VALUE = "DATA-VALUE";
        public static final String AMOUNT = "AMOUNT";
        public static final String NAME = "NAME";
        public static final String LORE = "LORE";
        public static final String ENCHANT = "ENCHANTMENT";
        public static final String COLOR = "COLOR";
        public static final String SKULL_OWNER = "SKULL-OWNER";
        public static final String COMMAND = "COMMAND";
        public static final String PRICE = "PRICE";
        public static final String POINTS = "POINTS";
        public static final String EXP_LEVELS = "LEVELS";
        public static final String REQUIRED_ITEM = "REQUIRED-ITEM";
        public static final String PERMISSION = "PERMISSION";
        public static final String PERMISSION_MESSAGE = "PERMISSION-MESSAGE";
        public static final String VIEW_PERMISSION = "VIEW-PERMISSION";
        public static final String KEEP_OPEN = "KEEP-OPEN";
        public static final String POSITION_X = "POSITION-X";
        public static final String POSITION_Y = "POSITION-Y";

        private Nodes() {
        }
    }
}

