/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.serializer;

import com.gmail.filoghost.chestcommands.util.ErrorLogger;
import com.gmail.filoghost.chestcommands.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;

public class EnchantmentSerializer {
    private static Map<String, Enchantment> enchantmentsMap = new HashMap<String, Enchantment>();

    static {
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Protection"), Enchantment.PROTECTION_ENVIRONMENTAL);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Fire Protection"), Enchantment.PROTECTION_FIRE);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Feather Falling"), Enchantment.PROTECTION_FALL);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Blast Protection"), Enchantment.PROTECTION_EXPLOSIONS);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Projectile Protection"), Enchantment.PROTECTION_PROJECTILE);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Respiration"), Enchantment.OXYGEN);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Aqua Affinity"), Enchantment.WATER_WORKER);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Thorns"), Enchantment.THORNS);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Sharpness"), Enchantment.DAMAGE_ALL);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Smite"), Enchantment.DAMAGE_UNDEAD);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Bane Of Arthropods"), Enchantment.DAMAGE_ARTHROPODS);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Knockback"), Enchantment.KNOCKBACK);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Fire Aspect"), Enchantment.FIRE_ASPECT);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Looting"), Enchantment.LOOT_BONUS_MOBS);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Efficiency"), Enchantment.DIG_SPEED);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Silk Touch"), Enchantment.SILK_TOUCH);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Unbreaking"), Enchantment.DURABILITY);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Fortune"), Enchantment.LOOT_BONUS_BLOCKS);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Power"), Enchantment.ARROW_DAMAGE);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Punch"), Enchantment.ARROW_KNOCKBACK);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Flame"), Enchantment.ARROW_FIRE);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Infinity"), Enchantment.ARROW_INFINITE);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Lure"), Enchantment.LURE);
        enchantmentsMap.put(EnchantmentSerializer.formatLowercase("Luck Of The Sea"), Enchantment.LUCK);
        Enchantment[] enchantmentArray = Enchantment.values();
        int n = enchantmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchantment enchant = enchantmentArray[n2];
            if (enchant != null) {
                enchantmentsMap.put(EnchantmentSerializer.formatLowercase(enchant.getName()), enchant);
            }
            ++n2;
        }
    }

    private static String formatLowercase(String string) {
        return StringUtils.stripChars(string, " _-").toLowerCase();
    }

    public static Map<Enchantment, Integer> loadEnchantments(String input, String iconName, String menuFileName, ErrorLogger errorLogger) {
        HashMap<Enchantment, Integer> output = new HashMap<Enchantment, Integer>();
        if (input == null || input.isEmpty()) {
            return output;
        }
        String[] stringArray = input.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchantment ench;
            String singleEnchant = stringArray[n2];
            int level = 1;
            if (singleEnchant.contains(",")) {
                String[] levelSplit = singleEnchant.split(",");
                try {
                    level = Integer.parseInt(levelSplit[1].trim());
                }
                catch (NumberFormatException ex) {
                    errorLogger.addError("The icon \"" + iconName + "\" in the menu \"" + menuFileName + "\" has an invalid enchantment level: " + levelSplit[1]);
                }
                singleEnchant = levelSplit[0];
            }
            if ((ench = EnchantmentSerializer.matchEnchantment(singleEnchant)) == null) {
                errorLogger.addError("The icon \"" + iconName + "\" in the menu \"" + menuFileName + "\" has an invalid enchantment: " + singleEnchant);
            } else {
                output.put(ench, level);
            }
            ++n2;
        }
        return output;
    }

    public static Enchantment matchEnchantment(String input) {
        if (input == null) {
            return null;
        }
        return enchantmentsMap.get(EnchantmentSerializer.formatLowercase(input));
    }
}

