/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.serializer;

import com.gmail.filoghost.chestcommands.ChestCommands;
import com.gmail.filoghost.chestcommands.internal.icon.IconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.BroadcastIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.ConsoleIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.DragonBarIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.GiveIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.GiveMoneyIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.GivePointsIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.OpIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.OpenIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.PlayerIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.ServerIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.SoundIconCommand;
import com.gmail.filoghost.chestcommands.internal.icon.command.TellIconCommand;
import com.gmail.filoghost.chestcommands.util.ErrorLogger;
import com.gmail.filoghost.chestcommands.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandSerializer {
    private static Map<Pattern, Class<? extends IconCommand>> commandTypesMap = Utils.newHashMap();

    static {
        commandTypesMap.put(CommandSerializer.commandPattern("console:"), ConsoleIconCommand.class);
        commandTypesMap.put(CommandSerializer.commandPattern("op:"), OpIconCommand.class);
        commandTypesMap.put(CommandSerializer.commandPattern("(open|menu):"), OpenIconCommand.class);
        commandTypesMap.put(CommandSerializer.commandPattern("server:?"), ServerIconCommand.class);
        commandTypesMap.put(CommandSerializer.commandPattern("tell:"), TellIconCommand.class);
        commandTypesMap.put(CommandSerializer.commandPattern("broadcast:"), BroadcastIconCommand.class);
        commandTypesMap.put(CommandSerializer.commandPattern("give:"), GiveIconCommand.class);
        commandTypesMap.put(CommandSerializer.commandPattern("give-?money:"), GiveMoneyIconCommand.class);
        commandTypesMap.put(CommandSerializer.commandPattern("give-?points:"), GivePointsIconCommand.class);
        commandTypesMap.put(CommandSerializer.commandPattern("sound:"), SoundIconCommand.class);
        commandTypesMap.put(CommandSerializer.commandPattern("dragon-?bar:"), DragonBarIconCommand.class);
    }

    private static Pattern commandPattern(String regex) {
        return Pattern.compile("^(?i)" + regex);
    }

    public static void checkClassConstructors(ErrorLogger errorLogger) {
        for (Class<? extends IconCommand> clazz : commandTypesMap.values()) {
            try {
                clazz.getDeclaredConstructor(String.class).newInstance("");
            }
            catch (Exception ex) {
                String className = clazz.getName().replace("Command", "");
                className = className.substring(className.lastIndexOf(46) + 1, className.length());
                errorLogger.addError("Unable to register the \"" + className + "\" command type(" + ex.getClass().getName() + "), please inform the developer (filoghost). The plugin will still work, but all the \"" + className + "\" commands will be treated as normal commands.");
            }
        }
    }

    public static List<IconCommand> readCommands(String input) {
        String separator = ChestCommands.getSettings().multiple_commands_separator;
        if (separator == null || separator.length() == 0) {
            separator = ";";
        }
        String[] split = input.split(Pattern.quote(separator));
        List<IconCommand> iconCommands = Utils.newArrayList();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            String trim = command.trim();
            if (trim.length() > 0) {
                iconCommands.add(CommandSerializer.matchCommand(trim));
            }
            ++n2;
        }
        return iconCommands;
    }

    public static IconCommand matchCommand(String input) {
        for (Map.Entry<Pattern, Class<? extends IconCommand>> entry : commandTypesMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(input);
            if (!matcher.find()) continue;
            String cleanCommand = matcher.replaceFirst("").trim();
            try {
                return entry.getValue().getDeclaredConstructor(String.class).newInstance(cleanCommand);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PlayerIconCommand(input);
    }
}

