/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.nms;

import com.gmail.filoghost.chestcommands.ChestCommands;
import com.gmail.filoghost.chestcommands.util.Utils;
import java.lang.reflect.Method;
import java.util.Collection;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AttributeRemover {
    private static boolean useItemFlags;
    private static boolean useReflection;
    private static Class<?> nbtTagCompoundClass;
    private static Class<?> nbtTagListClass;
    private static Class<?> nmsItemstackClass;
    private static Method asNmsCopyMethod;
    private static Method asCraftMirrorMethod;
    private static Method hasTagMethod;
    private static Method getTagMethod;
    private static Method setTagMethod;
    private static Method nbtSetMethod;

    public static boolean setup() {
        if (Utils.isClassLoaded("org.bukkit.inventory.ItemFlag")) {
            useItemFlags = true;
        } else {
            try {
                nbtTagCompoundClass = AttributeRemover.getNmsClass("NBTTagCompound");
                nbtTagListClass = AttributeRemover.getNmsClass("NBTTagList");
                nmsItemstackClass = AttributeRemover.getNmsClass("ItemStack");
                asNmsCopyMethod = AttributeRemover.getObcClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class);
                asCraftMirrorMethod = AttributeRemover.getObcClass("inventory.CraftItemStack").getMethod("asCraftMirror", nmsItemstackClass);
                hasTagMethod = nmsItemstackClass.getMethod("hasTag", new Class[0]);
                getTagMethod = nmsItemstackClass.getMethod("getTag", new Class[0]);
                setTagMethod = nmsItemstackClass.getMethod("setTag", nbtTagCompoundClass);
                nbtSetMethod = nbtTagCompoundClass.getMethod("set", String.class, AttributeRemover.getNmsClass("NBTBase"));
                useReflection = true;
            }
            catch (Exception e) {
                ChestCommands.getInstance().getLogger().info("Could not enable the attribute remover for this version (" + e + "). Attributes will show up on items.");
            }
        }
        return true;
    }

    private static Class<?> getNmsClass(String name) throws ClassNotFoundException {
        return Class.forName("net.minecraft.server." + Utils.getBukkitVersion() + "." + name);
    }

    private static Class<?> getObcClass(String name) throws ClassNotFoundException {
        return Class.forName("org.bukkit.craftbukkit." + Utils.getBukkitVersion() + "." + name);
    }

    public static ItemStack hideAttributes(ItemStack item) {
        if (item == null) {
            return null;
        }
        if (useItemFlags) {
            ItemMeta meta = item.getItemMeta();
            if (AttributeRemover.isNullOrEmpty(meta.getItemFlags())) {
                meta.addItemFlags(ItemFlag.values());
                item.setItemMeta(meta);
            }
            return item;
        }
        if (useReflection) {
            try {
                Object nbtCompound;
                Object nmsItemstack = asNmsCopyMethod.invoke(null, item);
                if (nmsItemstack == null) {
                    return item;
                }
                if (((Boolean)hasTagMethod.invoke(nmsItemstack, new Object[0])).booleanValue()) {
                    nbtCompound = getTagMethod.invoke(nmsItemstack, new Object[0]);
                } else {
                    nbtCompound = nbtTagCompoundClass.newInstance();
                    setTagMethod.invoke(nmsItemstack, nbtCompound);
                }
                if (nbtCompound == null) {
                    return item;
                }
                Object nbtList = nbtTagListClass.newInstance();
                nbtSetMethod.invoke(nbtCompound, "AttributeModifiers", nbtList);
                return (ItemStack)asCraftMirrorMethod.invoke(null, nmsItemstack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return item;
    }

    private static boolean isNullOrEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }
}

