/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.listener;

import com.gmail.filoghost.chestcommands.ChestCommands;
import com.gmail.filoghost.chestcommands.api.Icon;
import com.gmail.filoghost.chestcommands.api.IconMenu;
import com.gmail.filoghost.chestcommands.internal.BoundItem;
import com.gmail.filoghost.chestcommands.internal.MenuInventoryHolder;
import com.gmail.filoghost.chestcommands.task.ExecuteCommandsTask;
import com.gmail.filoghost.chestcommands.util.Utils;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class InventoryListener
implements Listener {
    private static Map<Player, Long> antiClickSpam = Utils.newHashMap();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onInteract(PlayerInteractEvent event) {
        if (event.hasItem() && event.getAction() != Action.PHYSICAL) {
            for (BoundItem boundItem : ChestCommands.getBoundItems()) {
                if (!boundItem.isValidTrigger(event.getItem(), event.getAction())) continue;
                if (event.getPlayer().hasPermission(boundItem.getMenu().getPermission())) {
                    boundItem.getMenu().open(event.getPlayer());
                    continue;
                }
                boundItem.getMenu().sendNoPermissionMessage((CommandSender)event.getPlayer());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getHolder() instanceof MenuInventoryHolder) {
            Icon icon;
            event.setCancelled(true);
            IconMenu menu = ((MenuInventoryHolder)event.getInventory().getHolder()).getIconMenu();
            int slot = event.getRawSlot();
            if (slot >= 0 && slot < menu.getSize() && (icon = menu.getIconRaw(slot)) != null && event.getInventory().getItem(slot) != null) {
                Player clicker = (Player)event.getWhoClicked();
                Long cooldownUntil = antiClickSpam.get(clicker);
                long now = System.currentTimeMillis();
                int minDelay = ChestCommands.getSettings().anti_click_spam_delay;
                if (minDelay > 0) {
                    if (cooldownUntil != null && cooldownUntil > now) {
                        return;
                    }
                    antiClickSpam.put(clicker, now + (long)minDelay);
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)ChestCommands.getInstance(), (Runnable)new ExecuteCommandsTask(clicker, icon));
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        antiClickSpam.remove(event.getPlayer());
    }
}

