/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.internal.icon.command;

import com.gmail.filoghost.chestcommands.internal.icon.IconCommand;
import com.gmail.filoghost.chestcommands.util.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SoundIconCommand
extends IconCommand {
    private Sound sound;
    private float pitch = 1.0f;
    private float volume = 1.0f;
    private String errorMessage;

    public SoundIconCommand(String command) {
        super(command);
        String[] split = command.split(",");
        this.sound = Utils.matchSound(split[0]);
        if (this.sound == null) {
            this.errorMessage = ChatColor.RED + "Invalid sound \"" + split[0].trim() + "\".";
            return;
        }
        if (split.length > 1) {
            try {
                this.pitch = Float.parseFloat(split[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (split.length > 2) {
            try {
                this.volume = Float.parseFloat(split[2].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void execute(Player player) {
        if (this.errorMessage != null) {
            player.sendMessage(this.errorMessage);
            return;
        }
        player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
    }
}

