/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.internal.icon.command;

import com.gmail.filoghost.chestcommands.bridge.PlayerPointsBridge;
import com.gmail.filoghost.chestcommands.internal.icon.IconCommand;
import com.gmail.filoghost.chestcommands.util.Utils;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class GivePointsIconCommand
extends IconCommand {
    private int pointsToGive;
    private String errorMessage;

    public GivePointsIconCommand(String command) {
        super(command);
        if (!Utils.isValidPositiveInteger(command)) {
            this.errorMessage = ChatColor.RED + "Invalid points amount: " + command;
            return;
        }
        this.pointsToGive = Integer.parseInt(command);
    }

    @Override
    public void execute(Player player) {
        if (this.errorMessage != null) {
            player.sendMessage(this.errorMessage);
            return;
        }
        if (PlayerPointsBridge.hasValidPlugin()) {
            PlayerPointsBridge.givePoints(player, this.pointsToGive);
        } else {
            player.sendMessage(ChatColor.RED + "The plugin PlayerPoints was not found. Please inform the staff.");
        }
    }
}

