/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.internal.icon.command;

import com.gmail.filoghost.chestcommands.bridge.EconomyBridge;
import com.gmail.filoghost.chestcommands.internal.icon.IconCommand;
import com.gmail.filoghost.chestcommands.util.Utils;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class GiveMoneyIconCommand
extends IconCommand {
    private double moneyToGive;
    private String errorMessage;

    public GiveMoneyIconCommand(String command) {
        super(command);
        if (!Utils.isValidPositiveDouble(command)) {
            this.errorMessage = ChatColor.RED + "Invalid money amount: " + command;
            return;
        }
        this.moneyToGive = Double.parseDouble(command);
    }

    @Override
    public void execute(Player player) {
        if (this.errorMessage != null) {
            player.sendMessage(this.errorMessage);
            return;
        }
        if (EconomyBridge.hasValidEconomy()) {
            EconomyBridge.giveMoney(player, this.moneyToGive);
        } else {
            player.sendMessage(ChatColor.RED + "Vault with a compatible economy plugin not found. Please inform the staff.");
        }
    }
}

