/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.internal.icon;

import com.gmail.filoghost.chestcommands.config.AsciiPlaceholders;
import com.gmail.filoghost.chestcommands.internal.Variable;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public abstract class IconCommand {
    protected String command;
    private List<Variable> containedVariables;

    public IconCommand(String command) {
        this.command = AsciiPlaceholders.placeholdersToSymbols(command).trim();
        this.containedVariables = new ArrayList<Variable>();
        Variable[] variableArray = Variable.values();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            if (command.contains(variable.getText())) {
                this.containedVariables.add(variable);
            }
            ++n2;
        }
    }

    public String getParsedCommand(Player executor) {
        if (this.containedVariables.isEmpty()) {
            return this.command;
        }
        String commandCopy = this.command;
        for (Variable variable : this.containedVariables) {
            commandCopy = commandCopy.replace(variable.getText(), variable.getReplacement(executor));
        }
        return commandCopy;
    }

    public abstract void execute(Player var1);
}

