/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.internal.icon;

import com.gmail.filoghost.chestcommands.ChestCommands;
import com.gmail.filoghost.chestcommands.api.Icon;
import com.gmail.filoghost.chestcommands.bridge.EconomyBridge;
import com.gmail.filoghost.chestcommands.bridge.PlayerPointsBridge;
import com.gmail.filoghost.chestcommands.internal.ExtendedIconMenu;
import com.gmail.filoghost.chestcommands.internal.MenuInventoryHolder;
import com.gmail.filoghost.chestcommands.internal.RequiredItem;
import com.gmail.filoghost.chestcommands.util.StringUtils;
import com.gmail.filoghost.chestcommands.util.Utils;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class ExtendedIcon
extends Icon {
    private String permission;
    private String permissionMessage;
    private String viewPermission;
    private boolean permissionNegated;
    private boolean viewPermissionNegated;
    private double moneyPrice;
    private int playerPointsPrice;
    private int expLevelsPrice;
    private RequiredItem requiredItem;

    public boolean canClickIcon(Player player) {
        if (this.permission == null) {
            return true;
        }
        if (this.permissionNegated) {
            return !player.hasPermission(this.permission);
        }
        return player.hasPermission(this.permission);
    }

    public void setPermission(String permission) {
        if (StringUtils.isNullOrEmpty(permission)) {
            permission = null;
        }
        if (permission != null && permission.startsWith("-")) {
            this.permissionNegated = true;
            permission = permission.substring(1, permission.length()).trim();
        }
        this.permission = permission;
    }

    public String getPermissionMessage() {
        return this.permissionMessage;
    }

    public void setPermissionMessage(String permissionMessage) {
        this.permissionMessage = permissionMessage;
    }

    public boolean hasViewPermission() {
        return this.viewPermission != null;
    }

    public boolean canViewIcon(Player player) {
        if (this.viewPermission == null) {
            return true;
        }
        if (this.viewPermissionNegated) {
            return !player.hasPermission(this.viewPermission);
        }
        return player.hasPermission(this.viewPermission);
    }

    public void setViewPermission(String viewPermission) {
        if (StringUtils.isNullOrEmpty(viewPermission)) {
            viewPermission = null;
        }
        if (viewPermission != null && viewPermission.startsWith("-")) {
            this.viewPermissionNegated = true;
            viewPermission = viewPermission.substring(1, viewPermission.length()).trim();
        }
        this.viewPermission = viewPermission;
    }

    public double getMoneyPrice() {
        return this.moneyPrice;
    }

    public void setMoneyPrice(double moneyPrice) {
        this.moneyPrice = moneyPrice;
    }

    public int getPlayerPointsPrice() {
        return this.playerPointsPrice;
    }

    public void setPlayerPointsPrice(int playerPointsPrice) {
        this.playerPointsPrice = playerPointsPrice;
    }

    public int getExpLevelsPrice() {
        return this.expLevelsPrice;
    }

    public void setExpLevelsPrice(int expLevelsPrice) {
        this.expLevelsPrice = expLevelsPrice;
    }

    public RequiredItem getRequiredItem() {
        return this.requiredItem;
    }

    public void setRequiredItem(RequiredItem requiredItem) {
        this.requiredItem = requiredItem;
    }

    @Override
    public String calculateName(Player pov) {
        return super.calculateName(pov);
    }

    @Override
    public List<String> calculateLore(Player pov) {
        return super.calculateLore(pov);
    }

    @Override
    public boolean onClick(Player player) {
        MenuInventoryHolder menuHolder;
        Inventory topInventory;
        InventoryView view;
        if (!this.canClickIcon(player)) {
            if (this.permissionMessage != null) {
                player.sendMessage(this.permissionMessage);
            } else {
                player.sendMessage(ChestCommands.getLang().default_no_icon_permission);
            }
            return this.closeOnClick;
        }
        if (this.moneyPrice > 0.0) {
            if (!EconomyBridge.hasValidEconomy()) {
                player.sendMessage(ChatColor.RED + "This command has a price, but Vault with a compatible economy plugin was not found. For security, the command has been blocked. Please inform the staff.");
                return this.closeOnClick;
            }
            if (!EconomyBridge.hasMoney(player, this.moneyPrice)) {
                player.sendMessage(ChestCommands.getLang().no_money.replace("{money}", EconomyBridge.formatMoney(this.moneyPrice)));
                return this.closeOnClick;
            }
        }
        if (this.playerPointsPrice > 0) {
            if (!PlayerPointsBridge.hasValidPlugin()) {
                player.sendMessage(ChatColor.RED + "This command has a price in points, but the plugin PlayerPoints was not found. For security, the command has been blocked. Please inform the staff.");
                return this.closeOnClick;
            }
            if (!PlayerPointsBridge.hasPoints(player, this.playerPointsPrice)) {
                player.sendMessage(ChestCommands.getLang().no_points.replace("{points}", Integer.toString(this.playerPointsPrice)));
                return this.closeOnClick;
            }
        }
        if (this.expLevelsPrice > 0 && player.getLevel() < this.expLevelsPrice) {
            player.sendMessage(ChestCommands.getLang().no_exp.replace("{levels}", Integer.toString(this.expLevelsPrice)));
            return this.closeOnClick;
        }
        if (this.requiredItem != null && !this.requiredItem.hasItem(player)) {
            player.sendMessage(ChestCommands.getLang().no_required_item.replace("{material}", Utils.formatMaterial(this.requiredItem.getMaterial())).replace("{id}", Integer.toString(this.requiredItem.getMaterial().getId())).replace("{amount}", Integer.toString(this.requiredItem.getAmount())).replace("{datavalue}", this.requiredItem.hasRestrictiveDataValue() ? Short.toString(this.requiredItem.getDataValue()) : ChestCommands.getLang().any));
            return this.closeOnClick;
        }
        boolean changedVariables = false;
        if (this.moneyPrice > 0.0) {
            if (!EconomyBridge.takeMoney(player, this.moneyPrice)) {
                player.sendMessage(ChatColor.RED + "Error: the transaction couldn't be executed. Please inform the staff.");
                return this.closeOnClick;
            }
            changedVariables = true;
        }
        if (this.playerPointsPrice > 0) {
            if (!PlayerPointsBridge.takePoints(player, this.playerPointsPrice)) {
                player.sendMessage(ChatColor.RED + "Error: the transaction couldn't be executed. Please inform the staff.");
                return this.closeOnClick;
            }
            changedVariables = true;
        }
        if (this.expLevelsPrice > 0) {
            player.setLevel(player.getLevel() - this.expLevelsPrice);
        }
        if (this.requiredItem != null) {
            this.requiredItem.takeItem(player);
        }
        if (changedVariables && (view = player.getOpenInventory()) != null && (topInventory = view.getTopInventory()).getHolder() instanceof MenuInventoryHolder && (menuHolder = (MenuInventoryHolder)topInventory.getHolder()).getIconMenu() instanceof ExtendedIconMenu) {
            ((ExtendedIconMenu)menuHolder.getIconMenu()).refresh(player, topInventory);
        }
        return super.onClick(player);
    }
}

