/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.internal;

import com.gmail.filoghost.chestcommands.bridge.EconomyBridge;
import com.gmail.filoghost.chestcommands.bridge.PlayerPointsBridge;
import com.gmail.filoghost.chestcommands.internal.CachedGetters;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public enum Variable {
    PLAYER("{player}"){

        @Override
        public String getReplacement(Player executor) {
            return executor.getName();
        }
    }
    ,
    ONLINE("{online}"){

        @Override
        public String getReplacement(Player executor) {
            return String.valueOf(CachedGetters.getOnlinePlayers());
        }
    }
    ,
    MAX_PLAYERS("{max_players}"){

        @Override
        public String getReplacement(Player executor) {
            return String.valueOf(Bukkit.getMaxPlayers());
        }
    }
    ,
    MONEY("{money}"){

        @Override
        public String getReplacement(Player executor) {
            if (EconomyBridge.hasValidEconomy()) {
                return EconomyBridge.formatMoney(EconomyBridge.getMoney(executor));
            }
            return "[ECONOMY PLUGIN NOT FOUND]";
        }
    }
    ,
    POINTS("{points}"){

        @Override
        public String getReplacement(Player executor) {
            if (PlayerPointsBridge.hasValidPlugin()) {
                return String.valueOf(PlayerPointsBridge.getPoints(executor));
            }
            return "[PLAYER POINTS PLUGIN NOT FOUND]";
        }
    }
    ,
    WORLD("{world}"){

        @Override
        public String getReplacement(Player executor) {
            return executor.getWorld().getName();
        }
    };

    private String text;

    private Variable(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public abstract String getReplacement(Player var1);

    /* synthetic */ Variable(String string, int n, String string2, Variable variable) {
        this(string2);
    }
}

