/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.internal;

import com.gmail.filoghost.chestcommands.util.Validate;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RequiredItem {
    private Material material;
    private int amount;
    private short dataValue;
    private boolean isDurabilityRestrictive = false;

    public RequiredItem(Material material, int amount) {
        Validate.notNull(material, "Material cannot be null");
        Validate.isTrue(material != Material.AIR, "Material cannot be air");
        this.material = material;
        this.amount = amount;
    }

    public ItemStack createItemStack() {
        return new ItemStack(this.material, this.amount, this.dataValue);
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    public short getDataValue() {
        return this.dataValue;
    }

    public void setRestrictiveDataValue(short data) {
        Validate.isTrue(data >= 0, "Data value cannot be negative");
        this.dataValue = data;
        this.isDurabilityRestrictive = true;
    }

    public boolean hasRestrictiveDataValue() {
        return this.isDurabilityRestrictive;
    }

    public boolean isValidDataValue(short data) {
        if (!this.isDurabilityRestrictive) {
            return true;
        }
        return data == this.dataValue;
    }

    public boolean hasItem(Player player) {
        int amountFound = 0;
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null && item.getType() == this.material && this.isValidDataValue(item.getDurability())) {
                amountFound += item.getAmount();
            }
            ++n2;
        }
        return amountFound >= this.amount;
    }

    public boolean takeItem(Player player) {
        if (this.amount <= 0) {
            return true;
        }
        int itemsToTake = this.amount;
        ItemStack[] contents = player.getInventory().getContents();
        ItemStack current = null;
        int i = 0;
        while (i < contents.length) {
            current = contents[i];
            if (current != null && current.getType() == this.material && this.isValidDataValue(current.getDurability())) {
                if (current.getAmount() > itemsToTake) {
                    current.setAmount(current.getAmount() - itemsToTake);
                    return true;
                }
                itemsToTake -= current.getAmount();
                player.getInventory().setItem(i, new ItemStack(Material.AIR));
            }
            if (itemsToTake <= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

