/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.internal;

import com.gmail.filoghost.chestcommands.ChestCommands;
import com.gmail.filoghost.chestcommands.api.IconMenu;
import com.gmail.filoghost.chestcommands.internal.MenuInventoryHolder;
import com.gmail.filoghost.chestcommands.internal.icon.ExtendedIcon;
import com.gmail.filoghost.chestcommands.internal.icon.IconCommand;
import com.gmail.filoghost.chestcommands.nms.AttributeRemover;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ExtendedIconMenu
extends IconMenu {
    private String fileName;
    private String permission;
    private List<IconCommand> openActions;
    private int refreshTicks;

    public ExtendedIconMenu(String title, int rows, String fileName) {
        super(title, rows);
        this.fileName = fileName;
        this.permission = "chestcommands.open." + fileName;
    }

    public List<IconCommand> getOpenActions() {
        return this.openActions;
    }

    public void setOpenActions(List<IconCommand> openAction) {
        this.openActions = openAction;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getRefreshTicks() {
        return this.refreshTicks;
    }

    public void setRefreshTicks(int refreshTicks) {
        this.refreshTicks = refreshTicks;
    }

    @Override
    public void open(Player player) {
        try {
            if (this.openActions != null) {
                for (IconCommand openAction : this.openActions) {
                    openAction.execute(player);
                }
            }
            Inventory inventory = Bukkit.createInventory((InventoryHolder)new MenuInventoryHolder(this), (int)this.icons.length, (String)this.title);
            int i = 0;
            while (i < this.icons.length) {
                if (this.icons[i] != null && (!(this.icons[i] instanceof ExtendedIcon) || ((ExtendedIcon)this.icons[i]).canViewIcon(player))) {
                    inventory.setItem(i, AttributeRemover.hideAttributes(this.icons[i].createItemstack(player)));
                }
                ++i;
            }
            player.openInventory(inventory);
        }
        catch (Exception e) {
            e.printStackTrace();
            player.sendMessage(ChatColor.RED + "An internal error occurred while opening the menu. The staff should check the console for errors.");
        }
    }

    public void refresh(Player player, Inventory inventory) {
        try {
            int i = 0;
            while (i < this.icons.length) {
                ExtendedIcon extIcon;
                if (this.icons[i] != null && this.icons[i] instanceof ExtendedIcon && ((extIcon = (ExtendedIcon)this.icons[i]).hasViewPermission() || extIcon.hasVariables())) {
                    if (extIcon.canViewIcon(player)) {
                        if (inventory.getItem(i) == null) {
                            ItemStack updatedIcon = extIcon.createItemstack(player);
                            inventory.setItem(i, updatedIcon);
                        }
                        ItemStack inventoryItem = AttributeRemover.hideAttributes(inventory.getItem(i));
                        ItemMeta meta = inventoryItem.getItemMeta();
                        meta.setDisplayName(extIcon.calculateName(player));
                        meta.setLore(extIcon.calculateLore(player));
                        inventoryItem.setItemMeta(meta);
                    } else {
                        inventory.setItem(i, null);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            player.sendMessage(ChatColor.RED + "An internal error occurred while refreshing the menu. The staff should check the console for errors.");
        }
    }

    public void sendNoPermissionMessage(CommandSender sender) {
        String noPermMessage = ChestCommands.getLang().no_open_permission;
        if (noPermMessage != null && !noPermMessage.isEmpty()) {
            sender.sendMessage(noPermMessage.replace("{permission}", this.permission));
        }
    }
}

