/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.internal;

import com.gmail.filoghost.chestcommands.internal.ExtendedIconMenu;
import com.gmail.filoghost.chestcommands.util.ClickType;
import com.gmail.filoghost.chestcommands.util.Validate;
import org.bukkit.Material;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;

public class BoundItem {
    private ExtendedIconMenu menu;
    private Material material;
    private short data;
    private ClickType clickType;

    public BoundItem(ExtendedIconMenu menu, Material material, ClickType clickType) {
        Validate.notNull(material, "Material cannot be null");
        Validate.notNull(material, "ClickType cannot be null");
        Validate.isTrue(material != Material.AIR, "Material cannot be AIR");
        this.menu = menu;
        this.material = material;
        this.clickType = clickType;
        this.data = (short)-1;
    }

    public void setRestrictiveData(short data) {
        this.data = data;
    }

    public ExtendedIconMenu getMenu() {
        return this.menu;
    }

    public boolean isValidTrigger(ItemStack item, Action action) {
        if (item == null) {
            return false;
        }
        if (this.material != item.getType()) {
            return false;
        }
        if (this.data != -1 && this.data != item.getDurability()) {
            return false;
        }
        return this.clickType.isValidInteract(action);
    }
}

