/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.config.yaml;

import com.gmail.filoghost.chestcommands.config.yaml.PluginConfig;
import com.gmail.filoghost.chestcommands.util.Utils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.InvalidConfigurationException;

public class SpecialConfig {
    private transient PluginConfig config;
    private transient String header;
    private transient Map<String, Object> defaultValuesMap;

    public SpecialConfig(PluginConfig config) {
        this.config = config;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void load() throws IOException, InvalidConfigurationException, Exception {
        if (this.defaultValuesMap == null) {
            this.defaultValuesMap = new HashMap<String, Object>();
            Field[] fieldArray = this.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (this.isValidField(field)) {
                    field.setAccessible(true);
                    String configKey = this.formatFieldName(field);
                    try {
                        Object defaultValue = field.get(this);
                        if (defaultValue != null) {
                            this.defaultValuesMap.put(configKey, defaultValue);
                        } else {
                            this.config.getPlugin().getLogger().warning("The field " + field.getName() + " was not provided with a default value, please inform the developer.");
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        this.config.load();
        boolean needsSave = false;
        for (Map.Entry<String, Object> entry : this.defaultValuesMap.entrySet()) {
            if (this.config.isSet(entry.getKey())) continue;
            needsSave = true;
            this.config.set(entry.getKey(), entry.getValue());
        }
        if (needsSave) {
            this.config.options().header(this.header);
            this.config.save();
        }
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n3 = 0;
        while (n3 < n) {
            Field field = fieldArray[n3];
            if (this.isValidField(field)) {
                field.setAccessible(true);
                String configKey = this.formatFieldName(field);
                if (this.config.isSet(configKey)) {
                    Class<?> type = field.getType();
                    if (type == Boolean.TYPE || type == Boolean.class) {
                        field.set(this, this.config.getBoolean(configKey));
                    } else if (type == Integer.TYPE || type == Integer.class) {
                        field.set(this, this.config.getInt(configKey));
                    } else if (type == Double.TYPE || type == Double.class) {
                        field.set(this, this.config.getDouble(configKey));
                    } else if (type == String.class) {
                        field.set(this, Utils.addColors(this.config.getString(configKey)));
                    } else {
                        this.config.getPlugin().getLogger().warning("Unknown field type: " + field.getType().getName() + " (" + field.getName() + "). Please inform the developer.");
                    }
                } else {
                    field.set(this, this.defaultValuesMap.get(configKey));
                }
            }
            ++n3;
        }
    }

    private boolean isValidField(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers);
    }

    private String formatFieldName(Field field) {
        return field.getName().replace("__", ".").replace("_", "-");
    }
}

