/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.command;

import com.gmail.filoghost.chestcommands.ChestCommands;
import com.gmail.filoghost.chestcommands.command.CommandFramework;
import com.gmail.filoghost.chestcommands.internal.ExtendedIconMenu;
import com.gmail.filoghost.chestcommands.internal.MenuInventoryHolder;
import com.gmail.filoghost.chestcommands.task.ErrorLoggerTask;
import com.gmail.filoghost.chestcommands.util.ErrorLogger;
import com.gmail.filoghost.chestcommands.util.VersionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
extends CommandFramework {
    public CommandHandler(String label) {
        super(label);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(CommandSender sender, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(ChestCommands.CHAT_PREFIX);
            sender.sendMessage(ChatColor.GREEN + "Version: " + ChatColor.GRAY + ChestCommands.getInstance().getDescription().getVersion());
            sender.sendMessage(ChatColor.GREEN + "Developer: " + ChatColor.GRAY + "filoghost");
            sender.sendMessage(ChatColor.GREEN + "Commands: " + ChatColor.GRAY + "/" + label + " help");
            return;
        }
        if (args[0].equalsIgnoreCase("help")) {
            CommandFramework.CommandValidate.isTrue(sender.hasPermission("chestcommands.command.help"), "You don't have permission.");
            sender.sendMessage(String.valueOf(ChestCommands.CHAT_PREFIX) + " Commands:");
            sender.sendMessage(ChatColor.WHITE + "/" + label + " reload" + ChatColor.GRAY + " - Reloads the plugin.");
            sender.sendMessage(ChatColor.WHITE + "/" + label + " list" + ChatColor.GRAY + " - Lists the loaded menus.");
            sender.sendMessage(ChatColor.WHITE + "/" + label + " open <menu> [player]" + ChatColor.GRAY + " - Opens a menu for a player.");
            return;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            CommandFramework.CommandValidate.isTrue(sender.hasPermission("chestcommands.command.reload"), "You don't have permission.");
            for (Player player : VersionUtils.getOnlinePlayers()) {
                if (player.getOpenInventory() == null || !(player.getOpenInventory().getTopInventory().getHolder() instanceof MenuInventoryHolder) && !(player.getOpenInventory().getBottomInventory().getHolder() instanceof MenuInventoryHolder)) continue;
                player.closeInventory();
            }
            ErrorLogger errorLogger = new ErrorLogger();
            ChestCommands.getInstance().load(errorLogger);
            ChestCommands.setLastReloadErrors(errorLogger.getSize());
            if (!errorLogger.hasErrors()) {
                sender.sendMessage(String.valueOf(ChestCommands.CHAT_PREFIX) + "Plugin reloaded.");
            } else {
                new ErrorLoggerTask(errorLogger).run();
                sender.sendMessage(String.valueOf(ChestCommands.CHAT_PREFIX) + ChatColor.RED + "Plugin reloaded with " + errorLogger.getSize() + " error(s).");
                if (!(sender instanceof ConsoleCommandSender)) {
                    sender.sendMessage(String.valueOf(ChestCommands.CHAT_PREFIX) + ChatColor.RED + "Please check the console.");
                }
            }
            return;
        }
        if (args[0].equalsIgnoreCase("open")) {
            void var4_13;
            CommandFramework.CommandValidate.isTrue(sender.hasPermission("chestcommands.command.open"), "You don't have permission.");
            CommandFramework.CommandValidate.minLength(args, 2, "Usage: /" + label + " open <menu> [player]");
            Object var4_9 = null;
            if (!(sender instanceof Player)) {
                CommandFramework.CommandValidate.minLength(args, 3, "You must specify a player from the console.");
                Player player = Bukkit.getPlayerExact((String)args[2]);
            } else if (args.length > 2) {
                CommandFramework.CommandValidate.isTrue(sender.hasPermission("chestcommands.command.open.others"), "You don't have permission to open menus for others.");
                Player player = Bukkit.getPlayerExact((String)args[2]);
            } else {
                Player player = (Player)sender;
            }
            CommandFramework.CommandValidate.notNull(var4_13, "That player is not online.");
            String menuName = args[1].toLowerCase().endsWith(".yml") ? args[1] : String.valueOf(args[1]) + ".yml";
            ExtendedIconMenu menu = ChestCommands.getFileNameToMenuMap().get(menuName);
            CommandFramework.CommandValidate.notNull(menu, "The menu \"" + menuName + "\" was not found.");
            if (!sender.hasPermission(menu.getPermission())) {
                menu.sendNoPermissionMessage(sender);
                return;
            }
            if (sender.getName().equalsIgnoreCase(var4_13.getName())) {
                if (!ChestCommands.getLang().open_menu.isEmpty()) {
                    sender.sendMessage(ChestCommands.getLang().open_menu.replace("{menu}", menuName));
                }
            } else if (!ChestCommands.getLang().open_menu_others.isEmpty()) {
                sender.sendMessage(ChestCommands.getLang().open_menu_others.replace("{menu}", menuName).replace("{player}", var4_13.getName()));
            }
            menu.open((Player)var4_13);
            return;
        }
        if (args[0].equalsIgnoreCase("list")) {
            CommandFramework.CommandValidate.isTrue(sender.hasPermission("chestcommands.command.list"), "You don't have permission.");
            sender.sendMessage(String.valueOf(ChestCommands.CHAT_PREFIX) + " Loaded menus:");
            for (String string : ChestCommands.getFileNameToMenuMap().keySet()) {
                sender.sendMessage(ChatColor.GRAY + "- " + ChatColor.WHITE + string);
            }
            return;
        }
        sender.sendMessage(ChatColor.RED + "Unknown sub-command \"" + args[0] + "\".");
    }
}

