/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.api;

import com.gmail.filoghost.chestcommands.api.Icon;
import com.gmail.filoghost.chestcommands.internal.MenuInventoryHolder;
import com.gmail.filoghost.chestcommands.nms.AttributeRemover;
import com.gmail.filoghost.chestcommands.util.Utils;
import com.gmail.filoghost.chestcommands.util.Validate;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class IconMenu {
    protected final String title;
    protected final Icon[] icons;

    public IconMenu(String title, int rows) {
        this.title = title;
        this.icons = new Icon[rows * 9];
    }

    public void setIcon(int x, int y, Icon icon) {
        int slot = Utils.makePositive(y - 1) * 9 + Utils.makePositive(x - 1);
        if (slot >= 0 && slot < this.icons.length) {
            this.icons[slot] = icon;
        }
    }

    public void setIconRaw(int slot, Icon icon) {
        if (slot >= 0 && slot < this.icons.length) {
            this.icons[slot] = icon;
        }
    }

    public Icon getIcon(int x, int y) {
        int slot = Utils.makePositive(y - 1) * 9 + Utils.makePositive(x - 1);
        if (slot >= 0 && slot < this.icons.length) {
            return this.icons[slot];
        }
        return null;
    }

    public Icon getIconRaw(int slot) {
        if (slot >= 0 && slot < this.icons.length) {
            return this.icons[slot];
        }
        return null;
    }

    public int getRows() {
        return this.icons.length / 9;
    }

    public int getSize() {
        return this.icons.length;
    }

    public String getTitle() {
        return this.title;
    }

    public void open(Player player) {
        Validate.notNull(player, "Player cannot be null");
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new MenuInventoryHolder(this), (int)this.icons.length, (String)this.title);
        int i = 0;
        while (i < this.icons.length) {
            if (this.icons[i] != null) {
                inventory.setItem(i, AttributeRemover.hideAttributes(this.icons[i].createItemstack(player)));
            }
            ++i;
        }
        player.openInventory(inventory);
    }

    public String toString() {
        return "IconMenu [title=" + this.title + ", icons=" + Arrays.toString(this.icons) + "]";
    }
}

