/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.chestcommands.api;

import com.gmail.filoghost.chestcommands.api.ClickHandler;
import com.gmail.filoghost.chestcommands.internal.Variable;
import com.gmail.filoghost.chestcommands.util.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Icon {
    private Material material;
    private int amount;
    private short dataValue;
    private String name;
    private List<String> lore;
    private Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    private Color color;
    private String skullOwner;
    protected boolean closeOnClick = true;
    private ClickHandler clickHandler;
    private Map<Integer, Set<Variable>> variables;
    private ItemStack cachedItem;

    public boolean hasVariables() {
        return this.variables != null;
    }

    public void setMaterial(Material material) {
        if (material == Material.AIR) {
            material = null;
        }
        this.material = material;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setAmount(int amount) {
        if (amount < 1) {
            amount = 1;
        } else if (amount > 127) {
            amount = 127;
        }
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setDataValue(short dataValue) {
        if (dataValue < 0) {
            dataValue = 0;
        }
        this.dataValue = dataValue;
    }

    public short getDataValue() {
        return this.dataValue;
    }

    public void setName(String name) {
        this.name = name;
        if (name == null) {
            return;
        }
        Variable[] variableArray = Variable.values();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            if (name.contains(variable.getText())) {
                Set<Variable> nameVariables;
                if (this.variables == null) {
                    this.variables = new HashMap<Integer, Set<Variable>>();
                }
                if ((nameVariables = this.variables.get(-1)) == null) {
                    nameVariables = new HashSet<Variable>();
                    this.variables.put(-1, nameVariables);
                }
                nameVariables.add(variable);
            }
            ++n2;
        }
    }

    public boolean hasName() {
        return this.name != null;
    }

    public void setLore(String ... lore) {
        if (lore != null) {
            this.setLore(Arrays.asList(lore));
        }
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
        if (lore == null) {
            return;
        }
        int i = 0;
        while (i < lore.size()) {
            Variable[] variableArray = Variable.values();
            int n = variableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Variable variable = variableArray[n2];
                if (lore.get(i).contains(variable.getText())) {
                    Set<Variable> lineVariables;
                    if (this.variables == null) {
                        this.variables = new HashMap<Integer, Set<Variable>>();
                    }
                    if ((lineVariables = this.variables.get(i)) == null) {
                        lineVariables = new HashSet<Variable>();
                        this.variables.put(i, lineVariables);
                    }
                    lineVariables.add(variable);
                }
                ++n2;
            }
            ++i;
        }
    }

    public boolean hasLore() {
        return this.lore != null && this.lore.size() > 0;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        if (enchantments == null) {
            this.clearEnchantments();
            return;
        }
        this.enchantments = enchantments;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return new HashMap<Enchantment, Integer>(this.enchantments);
    }

    public void addEnchantment(Enchantment ench) {
        this.addEnchantment(ench, 1);
    }

    public void addEnchantment(Enchantment ench, Integer level) {
        this.enchantments.put(ench, level);
    }

    public void removeEnchantment(Enchantment ench) {
        this.enchantments.remove(ench);
    }

    public void clearEnchantments() {
        this.enchantments.clear();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getSkullOwner() {
        return this.skullOwner;
    }

    public void setSkullOwner(String skullOwner) {
        this.skullOwner = skullOwner;
    }

    public void setCloseOnClick(boolean closeOnClick) {
        this.closeOnClick = closeOnClick;
    }

    public void setClickHandler(ClickHandler clickHandler) {
        this.clickHandler = clickHandler;
    }

    public ClickHandler getClickHandler() {
        return this.clickHandler;
    }

    protected String calculateName(Player pov) {
        if (this.hasName()) {
            Set<Variable> nameVariables;
            String name = this.name;
            if (pov != null && this.variables != null && (nameVariables = this.variables.get(-1)) != null) {
                for (Variable nameVariable : nameVariables) {
                    name = name.replace(nameVariable.getText(), nameVariable.getReplacement(pov));
                }
            }
            if (name.isEmpty()) {
                return ChatColor.WHITE.toString();
            }
            return name;
        }
        return null;
    }

    protected List<String> calculateLore(Player pov) {
        List<String> output = null;
        if (this.hasLore()) {
            output = Utils.newArrayList();
            if (pov != null && this.variables != null) {
                int i = 0;
                while (i < this.lore.size()) {
                    String line = this.lore.get(i);
                    Set<Variable> lineVariables = this.variables.get(i);
                    if (lineVariables != null) {
                        for (Variable lineVariable : lineVariables) {
                            line = line.replace(lineVariable.getText(), lineVariable.getReplacement(pov));
                        }
                    }
                    output.add(line);
                    ++i;
                }
            } else {
                output.addAll(this.lore);
            }
        }
        if (this.material == null) {
            if (output == null) {
                output = Utils.newArrayList();
            }
            output.add(ChatColor.RED + "(Invalid material)");
        }
        return output;
    }

    public ItemStack createItemstack(Player pov) {
        if (this.variables == null && this.cachedItem != null) {
            return this.cachedItem;
        }
        ItemStack itemStack = this.material != null ? new ItemStack(this.material, this.amount, this.dataValue) : new ItemStack(Material.BEDROCK, this.amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.calculateName(pov));
        itemMeta.setLore(this.calculateLore(pov));
        if (this.color != null && itemMeta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)itemMeta).setColor(this.color);
        }
        if (this.skullOwner != null && itemMeta instanceof SkullMeta) {
            ((SkullMeta)itemMeta).setOwner(this.skullOwner);
        }
        itemStack.setItemMeta(itemMeta);
        if (this.enchantments.size() > 0) {
            for (Map.Entry<Enchantment, Integer> entry : this.enchantments.entrySet()) {
                itemStack.addUnsafeEnchantment(entry.getKey(), entry.getValue().intValue());
            }
        }
        if (this.variables == null) {
            this.cachedItem = itemStack;
        }
        return itemStack;
    }

    public boolean onClick(Player whoClicked) {
        if (this.clickHandler != null) {
            return this.clickHandler.onClick(whoClicked);
        }
        return this.closeOnClick;
    }
}

